/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic.action.buttons;

import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonHandler;
import bibliothek.gui.dock.themes.basic.action.BasicDropDownButtonModel;
import bibliothek.gui.dock.themes.basic.action.buttons.MiniButton;
import bibliothek.gui.dock.util.DockUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;
import javax.swing.border.Border;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DropDownMiniButton
extends MiniButton<BasicDropDownButtonModel> {
    private Icon dropIcon;
    private Icon disabledDropIcon;
    private Color dropIconColor;
    private BasicDropDownButtonHandler handler;

    public DropDownMiniButton(BasicDropDownButtonHandler basicDropDownButtonHandler) {
        super(null);
        this.handler = basicDropDownButtonHandler;
        BasicDropDownButtonModel basicDropDownButtonModel = new BasicDropDownButtonModel(this, basicDropDownButtonHandler){

            public void changed() {
                DropDownMiniButton.this.updateBorder();
                DropDownMiniButton.this.repaint();
            }

            protected boolean inDropDownArea(int n, int n2) {
                return DropDownMiniButton.this.isOverDropIcon(n, n2);
            }
        };
        this.setModel(basicDropDownButtonModel);
        this.dropIcon = this.createDropIcon();
    }

    public void setDropIconColor(Color color) {
        this.dropIconColor = color;
        this.disabledDropIcon = null;
        this.repaint();
    }

    public Color getDropIconColor() {
        return this.dropIconColor;
    }

    @Override
    public void setForeground(Color color) {
        this.disabledDropIcon = null;
        super.setForeground(color);
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Insets insets = this.getMaxBorderInsets();
        Dimension dimension = ((BasicDropDownButtonModel)this.getModel()).getMaxIconSize();
        dimension.width = Math.max(dimension.width, 16);
        dimension.height = Math.max(dimension.height, 16);
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int n = insets.left + 2 * insets.right + dimension.width;
            int n2 = this.dropIcon.getIconHeight();
            n2 = dimension == null ? Math.max(n2, 16) : Math.max(n2, dimension.height);
            return new Dimension(n += this.dropIcon.getIconWidth(), n2 += insets.top + insets.bottom);
        }
        int n = insets.top + 2 * insets.bottom + dimension.height;
        int n3 = this.dropIcon.getIconWidth();
        n3 = dimension == null ? Math.max(n3, 16) : Math.max(n3, dimension.width);
        return new Dimension(n3 += insets.left + insets.right, n += this.dropIcon.getIconHeight());
    }

    @Override
    public void updateUI() {
        this.disabledDropIcon = null;
        if (this.handler != null) {
            this.handler.updateUI();
        }
        super.updateUI();
    }

    @Override
    public void paint(Graphics graphics) {
        Border border = this.getBorder();
        Icon icon = ((BasicDropDownButtonModel)this.getModel()).getPaintIcon();
        Insets insets = this.getMaxBorderInsets();
        Icon icon2 = this.dropIcon;
        if (!this.isEnabled()) {
            if (this.disabledDropIcon == null) {
                this.disabledDropIcon = DockUtilities.disabledIcon(this, this.dropIcon);
            }
            icon2 = this.disabledDropIcon;
        }
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int n = icon == null ? 16 : icon.getIconWidth();
            int n2 = this.dropIcon.getIconWidth();
            double d = insets.left + n + insets.right + n2 + insets.right;
            double d2 = (double)this.getWidth() / d;
            if (border != null) {
                border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
                if (((BasicDropDownButtonModel)this.getModel()).isMouseOverDropDown()) {
                    border.paintBorder(this, graphics, 0, 0, (int)(d2 * (double)(insets.left + insets.right + n)), this.getHeight());
                }
            }
            if (icon != null) {
                icon.paintIcon(this, graphics, (int)(d2 * (double)(insets.left + n / 2) - (double)(n / 2)), insets.top + (this.getHeight() - insets.top - insets.bottom - icon.getIconHeight()) / 2);
            }
            icon2.paintIcon(this, graphics, (int)(d2 * (double)(insets.left + insets.right + n + n2 / 2) - (double)(n2 / 2)), insets.top + (this.getHeight() - insets.top - insets.bottom - this.dropIcon.getIconHeight()) / 2);
        } else {
            int n = icon == null ? 16 : icon.getIconHeight();
            int n3 = this.dropIcon.getIconHeight();
            double d = insets.top + n + insets.bottom + n3 + insets.bottom;
            double d3 = (double)this.getHeight() / d;
            if (border != null) {
                border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
                if (((BasicDropDownButtonModel)this.getModel()).isMouseOverDropDown()) {
                    border.paintBorder(this, graphics, 0, 0, this.getWidth(), (int)(d3 * (double)(insets.top + insets.bottom + n)));
                }
            }
            if (icon != null) {
                icon.paintIcon(this, graphics, insets.left + (this.getWidth() - insets.left - insets.right - icon.getIconWidth()) / 2, (int)(d3 * (double)(insets.top + n / 2) - (double)(n / 2)));
            }
            icon2.paintIcon(this, graphics, insets.left + (this.getWidth() - insets.left - insets.right - this.dropIcon.getIconWidth()) / 2, (int)(d3 * (double)(insets.top + insets.bottom + n + n3 / 2) - (double)(n3 / 2)));
        }
        if (this.isFocusOwner() && this.isFocusable() && this.isEnabled()) {
            this.paintFocus(graphics);
        }
    }

    protected Icon createDropIcon() {
        return new Icon(){

            public int getIconHeight() {
                return 7;
            }

            public int getIconWidth() {
                return 7;
            }

            public void paintIcon(Component component, Graphics graphics, int n, int n2) {
                ++n;
                if (DropDownMiniButton.this.dropIconColor == null) {
                    graphics.setColor(DropDownMiniButton.this.getForeground());
                } else {
                    graphics.setColor(DropDownMiniButton.this.dropIconColor);
                }
                graphics.drawLine(n, n2 + 1, n + 4, n2 + 1);
                graphics.drawLine(n + 1, n2 + 2, n + 3, n2 + 2);
                graphics.drawLine(n + 2, n2 + 3, n + 2, n2 + 3);
            }
        };
    }

    public boolean isOverDropIcon(int n, int n2) {
        if (!this.contains(n, n2)) {
            return false;
        }
        Dimension dimension = ((BasicDropDownButtonModel)this.getModel()).getMaxIconSize();
        Insets insets = this.getMaxBorderInsets();
        if (((BasicDropDownButtonModel)this.getModel()).getOrientation().isHorizontal()) {
            int n3 = dimension.width < 16 ? 16 : dimension.width;
            int n4 = this.dropIcon.getIconWidth();
            double d = insets.left + n3 + insets.right + n4 + insets.right;
            double d2 = (double)this.getWidth() / d;
            int n5 = (int)(d2 * (double)(insets.left + insets.right + n3)) - insets.right;
            return n > n5;
        }
        int n6 = dimension.height < 16 ? 16 : dimension.height;
        int n7 = this.dropIcon.getIconHeight();
        double d = insets.top + n6 + insets.bottom + n7 + insets.bottom;
        double d3 = (double)this.getHeight() / d;
        int n8 = (int)(d3 * (double)(insets.top + insets.bottom + n6)) - insets.bottom;
        return n2 > n8;
    }
}

