/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.displayer.DisplayerFocusTraversalPolicy;
import bibliothek.gui.dock.displayer.DockableDisplayerHints;
import bibliothek.gui.dock.displayer.SingleTabDecider;
import bibliothek.gui.dock.event.SingleTabDeciderListener;
import bibliothek.gui.dock.focus.DockFocusTraversalPolicy;
import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.station.DockableDisplayerListener;
import bibliothek.gui.dock.themes.basic.BasicDockableDisplayerDecorator;
import bibliothek.gui.dock.themes.basic.MinimalDecorator;
import bibliothek.gui.dock.themes.basic.TabDecorator;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.util.PropertyValue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;

public class BasicDockableDisplayer
extends JPanel
implements DockableDisplayer {
    private Dockable dockable;
    private DockTitle title;
    private DockableDisplayer.Location location;
    private DockStation station;
    private DockController controller;
    private Hints hints = new Hints();
    private boolean respectBorderHint = false;
    private boolean defaultBorderHint = true;
    private boolean singleTabShowInnerBorder = true;
    private boolean singleTabShowOuterBorder = true;
    private List<DockableDisplayerListener> listeners = new ArrayList<DockableDisplayerListener>();
    private SingleTabDeciderListener singleTabListener = new SingleTabDeciderListener(){

        public void showSingleTabChanged(SingleTabDecider singleTabDecider, Dockable dockable) {
            if (dockable == BasicDockableDisplayer.this.dockable) {
                BasicDockableDisplayer.this.updateDecorator();
            }
        }
    };
    private PropertyValue<SingleTabDecider> decider = new PropertyValue<SingleTabDecider>(SingleTabDecider.SINGLE_TAB_DECIDER){

        @Override
        protected void valueChanged(SingleTabDecider singleTabDecider, SingleTabDecider singleTabDecider2) {
            if (singleTabDecider != null) {
                singleTabDecider.removeSingleTabDeciderListener(BasicDockableDisplayer.this.singleTabListener);
            }
            if (singleTabDecider2 != null) {
                singleTabDecider2.addSingleTabDeciderListener(BasicDockableDisplayer.this.singleTabListener);
            }
            BasicDockableDisplayer.this.updateDecorator();
        }
    };
    private BasicDockableDisplayerDecorator decorator;
    private boolean singleTabShowing;
    private JPanel content = new JPanel(null){

        public void doLayout() {
            BasicDockableDisplayer.this.doLayout(BasicDockableDisplayer.this.content);
        }

        public Dimension getMinimumSize() {
            return BasicDockableDisplayer.this.getContentMinimumSize();
        }
    };

    public BasicDockableDisplayer(DockStation dockStation) {
        this(dockStation, null, null);
    }

    public BasicDockableDisplayer(DockStation dockStation, Dockable dockable, DockTitle dockTitle) {
        this(dockStation, dockable, dockTitle, DockableDisplayer.Location.TOP);
    }

    public BasicDockableDisplayer(DockStation dockStation, Dockable dockable, DockTitle dockTitle, DockableDisplayer.Location location) {
        super(new GridLayout(1, 1));
        this.init(dockStation, dockable, dockTitle, location);
    }

    protected BasicDockableDisplayer(DockStation dockStation, boolean bl) {
        super(new GridLayout(1, 1));
        if (bl) {
            this.init(dockStation, null, null, DockableDisplayer.Location.TOP);
        }
    }

    protected void init(DockStation dockStation, Dockable dockable, DockTitle dockTitle, DockableDisplayer.Location location) {
        this.content.setOpaque(false);
        this.setDecorator(new MinimalDecorator());
        this.setTitleLocation(location);
        this.setDockable(dockable);
        this.setTitle(dockTitle);
        this.setFocusable(true);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new DockFocusTraversalPolicy(new DisplayerFocusTraversalPolicy(this), true));
    }

    protected void setDecorator(BasicDockableDisplayerDecorator basicDockableDisplayerDecorator) {
        Component component;
        if (basicDockableDisplayerDecorator == null) {
            throw new IllegalArgumentException("decorator must not be null");
        }
        if (this.decorator != null) {
            component = this.decorator.getComponent();
            this.remove(component);
            this.decorator.setDockable(null, null);
            this.decorator.setController(null);
        }
        this.decorator = basicDockableDisplayerDecorator;
        basicDockableDisplayerDecorator.setController(this.controller);
        basicDockableDisplayerDecorator.setDockable(this.content, this.dockable);
        component = basicDockableDisplayerDecorator.getComponent();
        if (component != null) {
            this.add(component);
        }
        this.revalidate();
        this.repaint();
    }

    protected void updateDecorator() {
        if (this.dockable != null && this.station != null) {
            boolean bl = this.decider.getValue().showSingleTab(this.station, this.dockable);
            if (bl != this.singleTabShowing) {
                this.singleTabShowing = bl;
                if (this.singleTabShowing) {
                    this.setDecorator(new TabDecorator(this.station));
                } else {
                    this.setDecorator(new MinimalDecorator());
                }
            }
            this.updateBorder();
        }
    }

    public void setController(DockController dockController) {
        Component component = this.decorator.getComponent();
        this.controller = dockController;
        this.decider.setProperties(dockController);
        this.decorator.setController(dockController);
        Component component2 = this.decorator.getComponent();
        if (component != component2) {
            if (component != null) {
                this.remove(component);
            }
            if (component2 != null) {
                this.add(component2);
            }
            this.revalidate();
        }
    }

    public DockController getController() {
        return this.controller;
    }

    public void addDockableDisplayerListener(DockableDisplayerListener dockableDisplayerListener) {
        this.listeners.add(dockableDisplayerListener);
    }

    public void removeDockableDisplayerListener(DockableDisplayerListener dockableDisplayerListener) {
        this.listeners.remove(dockableDisplayerListener);
    }

    protected DockableDisplayerListener[] listeners() {
        return this.listeners.toArray(new DockableDisplayerListener[this.listeners.size()]);
    }

    public void setStation(DockStation dockStation) {
        this.station = dockStation;
    }

    public DockStation getStation() {
        return this.station;
    }

    public Dockable getDockable() {
        return this.dockable;
    }

    public void setDockable(Dockable dockable) {
        Component component;
        Component component2 = this.decorator.getComponent();
        if (this.dockable != null) {
            this.removeDockable(this.dockable, this.dockable.getComponent());
            this.dockable.configureDisplayerHints(null);
        }
        this.updateDecorator();
        this.decorator.setDockable(this.content, dockable);
        this.hints.setShowBorderHint(null);
        this.dockable = dockable;
        if (dockable != null) {
            this.dockable.configureDisplayerHints(this.hints);
            this.addDockable(dockable, dockable.getComponent());
        }
        if (component2 != (component = this.decorator.getComponent())) {
            if (component2 != null) {
                this.remove(component2);
            }
            if (component != null) {
                this.add(component);
            }
        }
        this.revalidate();
    }

    public DockableDisplayer.Location getTitleLocation() {
        return this.location;
    }

    public void setTitleLocation(DockableDisplayer.Location location) {
        if (location == null) {
            location = DockableDisplayer.Location.TOP;
        }
        this.location = location;
        if (this.title != null) {
            this.title.setOrientation(this.orientation(location));
        }
        this.revalidate();
    }

    protected DockTitle.Orientation orientation(DockableDisplayer.Location location) {
        switch (location) {
            case TOP: {
                return DockTitle.Orientation.NORTH_SIDED;
            }
            case BOTTOM: {
                return DockTitle.Orientation.SOUTH_SIDED;
            }
            case LEFT: {
                return DockTitle.Orientation.WEST_SIDED;
            }
            case RIGHT: {
                return DockTitle.Orientation.EAST_SIDED;
            }
        }
        return null;
    }

    public DockTitle getTitle() {
        return this.title;
    }

    public void setTitle(DockTitle dockTitle) {
        if (this.title != null) {
            this.removeTitle(this.title.getComponent());
        }
        this.title = dockTitle;
        if (dockTitle != null) {
            dockTitle.setOrientation(this.orientation(this.location));
            this.addTitle(dockTitle.getComponent());
        }
        this.revalidate();
    }

    protected void addDockable(Dockable dockable, Component component) {
        if (component != null) {
            this.content.add(component);
        }
    }

    protected void removeDockable(Dockable dockable, Component component) {
        if (component != null) {
            this.content.remove(component);
        }
    }

    protected Component getComponent(Dockable dockable) {
        return dockable.getComponent();
    }

    public JPanel getContent() {
        return this.content;
    }

    protected void addTitle(Component component) {
        this.content.add(component);
    }

    protected void removeTitle(Component component) {
        this.content.remove(component);
    }

    protected Component getComponent(DockTitle dockTitle) {
        return dockTitle.getComponent();
    }

    public boolean titleContains(int n, int n2) {
        DockTitle dockTitle = this.getTitle();
        if (dockTitle == null) {
            return false;
        }
        Component component = this.getComponent(dockTitle);
        Point point = new Point(n, n2);
        point = SwingUtilities.convertPoint(this, point, component);
        point.x -= component.getX();
        point.y -= component.getY();
        return component.contains(point);
    }

    public Component getComponent() {
        return this;
    }

    public Dimension getContentMinimumSize() {
        Cloneable cloneable;
        Dimension dimension;
        if (this.title == null && this.dockable != null) {
            dimension = this.getComponent(this.dockable).getMinimumSize();
        } else if (this.dockable == null && this.title != null) {
            dimension = this.getComponent(this.title).getMinimumSize();
        } else if (this.dockable == null && this.title == null) {
            dimension = new Dimension(0, 0);
        } else if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
            cloneable = this.getComponent(this.title).getMinimumSize();
            dimension = this.getComponent(this.dockable).getMinimumSize();
            dimension = new Dimension(dimension.width + ((Dimension)cloneable).width, Math.max(dimension.height, ((Dimension)cloneable).height));
        } else {
            cloneable = this.getComponent(this.title).getMinimumSize();
            dimension = this.getComponent(this.dockable).getMinimumSize();
            dimension = new Dimension(Math.max(((Dimension)cloneable).width, dimension.width), ((Dimension)cloneable).height + dimension.height);
        }
        cloneable = this.getInsets();
        if (cloneable != null) {
            dimension = new Dimension(dimension.width + cloneable.left + cloneable.right, dimension.height + cloneable.top + cloneable.bottom);
        }
        return dimension;
    }

    protected void doLayout(JPanel jPanel) {
        Insets insets = jPanel.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int n = insets.left;
        int n2 = insets.top;
        int n3 = jPanel.getWidth() - insets.left - insets.right;
        int n4 = jPanel.getHeight() - insets.top - insets.bottom;
        if (this.title == null && this.dockable == null) {
            return;
        }
        n3 = Math.max(0, n3);
        n4 = Math.max(0, n4);
        if (this.title == null) {
            this.getComponent(this.dockable).setBounds(n, n2, n3, n4);
        } else if (this.dockable == null) {
            this.getComponent(this.title).setBounds(n, n2, n3, n4);
        } else {
            Dimension dimension = this.getComponent(this.title).getPreferredSize();
            int n5 = dimension.width;
            int n6 = dimension.height;
            if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
                n5 = Math.min(n5, n3);
                n6 = n4;
            } else {
                n5 = n3;
                n6 = Math.min(n6, n4);
            }
            if (this.location == DockableDisplayer.Location.LEFT) {
                this.getComponent(this.title).setBounds(n, n2, n5, n6);
                this.getComponent(this.dockable).setBounds(n + n5, n2, n3 - n5, n4);
            } else if (this.location == DockableDisplayer.Location.RIGHT) {
                this.getComponent(this.title).setBounds(n + n3 - n5, n2, n5, n6);
                this.getComponent(this.dockable).setBounds(n, n2, n3 - n5, n6);
            } else if (this.location == DockableDisplayer.Location.BOTTOM) {
                this.getComponent(this.title).setBounds(n, n2 + n4 - n6, n5, n6);
                this.getComponent(this.dockable).setBounds(n, n2, n5, n4 - n6);
            } else {
                this.getComponent(this.title).setBounds(n, n2, n5, n6);
                this.getComponent(this.dockable).setBounds(n, n2 + n6, n5, n4 - n6);
            }
        }
    }

    public Insets getDockableInsets() {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.title == null && this.dockable == null) {
            return insets;
        }
        if (this.title == null) {
            return insets;
        }
        if (this.dockable != null) {
            Dimension dimension = this.getComponent(this.title).getPreferredSize();
            if (this.location == DockableDisplayer.Location.LEFT) {
                insets.left += dimension.width;
            } else if (this.location == DockableDisplayer.Location.RIGHT) {
                insets.right += dimension.width;
            } else if (this.location == DockableDisplayer.Location.BOTTOM) {
                insets.bottom += dimension.height;
            } else {
                insets.top += dimension.height;
            }
        }
        return insets;
    }

    protected Hints getHints() {
        return this.hints;
    }

    public void setRespectBorderHint(boolean bl) {
        if (this.respectBorderHint != bl) {
            this.respectBorderHint = bl;
            this.updateBorder();
        }
    }

    public boolean isRespectBorderHint() {
        return this.respectBorderHint;
    }

    public void setDefaultBorderHint(boolean bl) {
        if (this.defaultBorderHint != bl) {
            this.defaultBorderHint = bl;
            this.updateBorder();
        }
    }

    public boolean getDefaultBorderHint() {
        return this.defaultBorderHint;
    }

    public void setSingleTabShowInnerBorder(boolean bl) {
        this.singleTabShowInnerBorder = bl;
        this.updateBorder();
    }

    public boolean isSingleTabShowInnerBorder() {
        return this.singleTabShowInnerBorder;
    }

    public void setSingleTabShowOuterBorder(boolean bl) {
        this.singleTabShowOuterBorder = bl;
        this.updateBorder();
    }

    public boolean isSingleTabShowOuterBorder() {
        return this.singleTabShowOuterBorder;
    }

    protected void updateBorder() {
        if (this.singleTabShowing) {
            if (this.singleTabShowInnerBorder) {
                this.content.setBorder(this.getDefaultBorder());
            } else {
                this.content.setBorder(null);
            }
            if (this.singleTabShowOuterBorder) {
                this.setBorder(this.getDefaultBorder());
            } else {
                this.setBorder(null);
            }
        } else {
            this.content.setBorder(null);
            if (this.respectBorderHint) {
                boolean bl = this.hints.getShowBorderHint();
                if (bl) {
                    this.setBorder(this.getDefaultBorder());
                } else {
                    this.setBorder(null);
                }
            } else if (this.defaultBorderHint) {
                this.setBorder(this.getDefaultBorder());
            } else {
                this.setBorder(null);
            }
        }
    }

    protected Border getDefaultBorder() {
        return BorderFactory.createBevelBorder(0);
    }

    protected class Hints
    implements DockableDisplayerHints {
        private Boolean border;

        protected Hints() {
        }

        public void setShowBorderHint(Boolean bl) {
            if (this.border != bl) {
                this.border = bl;
                BasicDockableDisplayer.this.updateBorder();
            }
        }

        public boolean getShowBorderHint() {
            if (this.border != null) {
                return this.border;
            }
            return BasicDockableDisplayer.this.defaultBorderHint;
        }
    }
}

