/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemAdapter;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StrategyPlaceholderListItemConverter<D extends PlaceholderListItem>
extends PlaceholderListItemAdapter<D> {
    private PlaceholderStrategy strategy;

    public StrategyPlaceholderListItemConverter(PlaceholderStrategy placeholderStrategy) {
        this.strategy = placeholderStrategy;
    }

    public PlaceholderStrategy getStrategy() {
        return this.strategy;
    }

    @Override
    public ConvertedPlaceholderListItem convert(int n, D d) {
        if (this.strategy != null && d != null) {
            ConvertedPlaceholderListItem convertedPlaceholderListItem = new ConvertedPlaceholderListItem();
            convertedPlaceholderListItem.setPlaceholder(this.strategy.getPlaceholderFor(d.asDockable()));
            DockStation dockStation = d.asDockable().asDockStation();
            if (dockStation != null) {
                convertedPlaceholderListItem.setPlaceholderMap(dockStation.getPlaceholders());
            }
            return convertedPlaceholderListItem;
        }
        return null;
    }
}

