/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.support;

import bibliothek.gui.DockStation;
import bibliothek.gui.dock.station.support.ConvertedPlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItem;
import bibliothek.gui.dock.station.support.PlaceholderListItemConverter;
import bibliothek.gui.dock.station.support.PlaceholderMap;
import bibliothek.gui.dock.station.support.PlaceholderMetaMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.gui.dock.station.support.PlaceholderStrategyListener;
import bibliothek.gui.dock.station.support.StrategyPlaceholderListItemConverter;
import bibliothek.util.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlaceholderList<D extends PlaceholderListItem> {
    private PlaceholderStrategy strategy;
    private Entry head = null;
    private Entry headPlaceholder = null;
    private Entry headDockable = null;
    private SubList<Item> allItems = new SubList<Item>(Level.BASE){

        @Override
        protected Item wrap(Item item) {
            return item;
        }

        @Override
        protected boolean visible(Item item) {
            return true;
        }

        @Override
        protected Item unwrap(Item item) {
            return item;
        }
    };
    private SubList<Set<Path>> allPlaceholders = new SubList<Set<Path>>(Level.BASE){

        @Override
        protected Item wrap(Set<Path> set) {
            return new Item(PlaceholderList.this, set);
        }

        @Override
        protected boolean visible(Item item) {
            return item.isPlaceholder();
        }

        @Override
        protected Set<Path> unwrap(Item item) {
            Set<Path> set = item.getPlaceholderSet();
            if (set == null) {
                return Collections.emptySet();
            }
            return set;
        }
    };
    private SubList<Set<Path>> purePlaceholders = new SubList<Set<Path>>(Level.PLACEHOLDER){

        @Override
        protected Item wrap(Set<Path> set) {
            return new Item(PlaceholderList.this, set);
        }

        @Override
        protected boolean visible(Item item) {
            return item.isPlaceholder();
        }

        @Override
        protected Set<Path> unwrap(Item item) {
            return item.getPlaceholderSet();
        }
    };
    private SubList<D> dockables = new SubList<D>(Level.DOCKABLE){

        @Override
        protected Item wrap(D d) {
            return new Item(PlaceholderList.this, d);
        }

        @Override
        protected boolean visible(Item item) {
            return !item.isPlaceholder();
        }

        @Override
        protected D unwrap(Item item) {
            return item.getDockable();
        }

        @Override
        public void add(int n, D d) {
            Path path;
            super.add(n, d);
            if (PlaceholderList.this.strategy != null && (path = PlaceholderList.this.strategy.getPlaceholderFor(d.asDockable())) != null) {
                PlaceholderList.this.removeAll(path);
            }
        }
    };
    private PlaceholderStrategyListener listener = new PlaceholderStrategyListener(){

        @Override
        public void placeholderInvalidated(Set<Path> set) {
            PlaceholderList.this.removeAll(set);
        }
    };
    private boolean bound = false;

    public PlaceholderList() {
    }

    public PlaceholderList(PlaceholderMap placeholderMap) {
        this.read(placeholderMap, new StrategyPlaceholderListItemConverter(null));
    }

    public PlaceholderList(PlaceholderMap placeholderMap, PlaceholderListItemConverter<D> placeholderListItemConverter) {
        this.read(placeholderMap, placeholderListItemConverter);
    }

    public static <D extends PlaceholderListItem> void simulatedRead(PlaceholderMap placeholderMap, PlaceholderListItemConverter<D> placeholderListItemConverter) {
        PlaceholderList<D> placeholderList = new PlaceholderList<D>();
        super.read(placeholderMap, placeholderListItemConverter, true);
    }

    public void read(PlaceholderMap placeholderMap, PlaceholderListItemConverter<D> placeholderListItemConverter) {
        this.read(placeholderMap, placeholderListItemConverter, false);
    }

    private void read(PlaceholderMap placeholderMap, PlaceholderListItemConverter<D> placeholderListItemConverter, boolean bl) {
        if (placeholderListItemConverter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        if (!placeholderMap.getFormat().equals(new Path("dock.PlaceholderList"))) {
            throw new IllegalArgumentException("unknown format: " + placeholderMap.getFormat());
        }
        if (placeholderMap.getVersion() != 0) {
            throw new IllegalArgumentException("version unknown: " + placeholderMap.getVersion());
        }
        PlaceholderMap.Key[] keyArray = placeholderMap.getPlaceholders();
        int n = keyArray.length;
        for (int i = 0; i < n; ++i) {
            String string;
            Object object;
            int n2;
            Object object2;
            Object object3;
            HashSet<Path> hashSet = null;
            if (!bl && ((Path[])(object3 = keyArray[i].getPlaceholders())).length > 0) {
                hashSet = new HashSet<Path>();
                for (Path path : object3) {
                    hashSet.add(path);
                }
            }
            object3 = null;
            if (placeholderMap.contains(keyArray[i], "convert")) {
                Object[] objectArray;
                object2 = new ConvertedPlaceholderListItem();
                Object[] objectArray2 = objectArray = placeholderMap.getArray(keyArray[i], "convert-keys");
                int n3 = objectArray2.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = objectArray2[n2];
                    string = (String)object;
                    ((PlaceholderMetaMap)object2).put(string, placeholderMap.get(keyArray[i], "dock." + string));
                }
                object3 = placeholderListItemConverter.convert((ConvertedPlaceholderListItem)object2);
            }
            if (!bl) {
                object2 = object3 == null ? new Item(this, hashSet) : new Item(this, (PlaceholderListItem)object3, hashSet, null);
                if (placeholderMap.contains(keyArray[i], "map")) {
                    ((Item)object2).setPlaceholderMap(placeholderMap.getMap(keyArray[i], "map"));
                }
                if (placeholderMap.contains(keyArray[i], "item")) {
                    Object[] objectArray;
                    Object[] objectArray3 = objectArray = placeholderMap.getArray(keyArray[i], "item-keys");
                    int n4 = objectArray3.length;
                    for (n2 = 0; n2 < n4; ++n2) {
                        object = objectArray3[n2];
                        string = (String)object;
                        ((PlaceholderMetaMap)object2).put(string, placeholderMap.get(keyArray[i], "item." + string));
                    }
                }
                this.list().add((Item)object2);
            }
            if (object3 == null) continue;
            placeholderListItemConverter.added((Path[])object3);
        }
    }

    public PlaceholderMap toMap() {
        return this.toMap(new StrategyPlaceholderListItemConverter(this.strategy));
    }

    public PlaceholderMap toMap(PlaceholderListItemConverter<? super D> placeholderListItemConverter) {
        if (placeholderListItemConverter == null) {
            throw new IllegalArgumentException("converter must not be null");
        }
        PlaceholderMap placeholderMap = new PlaceholderMap(new Path("dock.PlaceholderList"), 0);
        int n = 0;
        for (Item item : this.list()) {
            String[] stringArray;
            Set<Path> set = item.getPlaceholderSet();
            if (set == null) {
                set = Collections.emptySet();
            }
            PlaceholderMap placeholderMap2 = item.getPlaceholderMap();
            Path path = null;
            Object d = item.getDockable();
            ConvertedPlaceholderListItem convertedPlaceholderListItem = null;
            if (d != null && (convertedPlaceholderListItem = placeholderListItemConverter.convert(n, d)) != null) {
                path = convertedPlaceholderListItem.getPlaceholder();
                if (placeholderMap2 == null) {
                    placeholderMap2 = convertedPlaceholderListItem.getPlaceholderMap();
                }
            }
            if (!item.isPlaceholder()) {
                ++n;
            }
            if (path != null && set.contains(path)) {
                path = null;
            }
            Path[] pathArray = new Path[set.size() + (path == null ? 0 : 1)];
            set.toArray(pathArray);
            if (path != null) {
                pathArray[pathArray.length - 1] = path;
            }
            if (pathArray.length <= 0 && convertedPlaceholderListItem == null) continue;
            PlaceholderMap.Key key = placeholderMap.newUniqueKey(pathArray);
            placeholderMap.add(key);
            if (placeholderMap2 != null) {
                placeholderMap.put(key, "map", placeholderMap2);
            }
            if (convertedPlaceholderListItem != null) {
                placeholderMap.put(key, "convert", true);
                stringArray = convertedPlaceholderListItem.keys();
                placeholderMap.put(key, "convert-keys", stringArray);
                for (String string : stringArray) {
                    placeholderMap.put(key, "dock." + string, convertedPlaceholderListItem.get(string));
                }
            }
            if ((stringArray = item.keys()).length <= 0) continue;
            placeholderMap.put(key, "item", true);
            placeholderMap.put(key, "item-keys", stringArray);
            for (String string : stringArray) {
                placeholderMap.put(key, "item." + string, item.get(string));
            }
        }
        return placeholderMap;
    }

    public void bind() {
        if (!this.bound) {
            this.bound = true;
            if (this.strategy != null) {
                this.strategy.addListener(this.listener);
                for (Item item : this.list()) {
                    item.setStrategy(this.strategy);
                }
                this.checkAllPlaceholders();
            }
        }
    }

    public void unbind() {
        if (this.bound) {
            this.bound = false;
            if (this.strategy != null) {
                this.strategy.removeListener(this.listener);
                for (Item item : this.list()) {
                    item.setStrategy(null);
                }
            }
        }
    }

    public PlaceholderStrategy getStrategy() {
        return this.strategy;
    }

    public void setStrategy(PlaceholderStrategy placeholderStrategy) {
        if (this.bound) {
            if (this.strategy != null) {
                this.strategy.removeListener(this.listener);
            }
            this.strategy = placeholderStrategy;
            if (this.strategy != null) {
                this.strategy.addListener(this.listener);
            }
            for (Item item : this.list()) {
                item.setStrategy(placeholderStrategy);
            }
            this.checkAllPlaceholders();
        } else {
            this.strategy = placeholderStrategy;
        }
    }

    private void checkAllPlaceholders() {
        if (this.strategy != null) {
            Iterator iterator = this.list().iterator();
            while (iterator.hasNext()) {
                Item item = (Item)iterator.next();
                Set<Path> set = item.getPlaceholderSet();
                if (set != null) {
                    Iterator<Path> iterator2 = set.iterator();
                    while (iterator2.hasNext()) {
                        if (this.strategy.isValidPlaceholder(iterator2.next())) continue;
                        iterator2.remove();
                    }
                }
                if (set != null && !set.isEmpty() || !item.isPlaceholder()) continue;
                iterator.remove();
            }
        }
    }

    public void insertAllPlaceholders() {
        if (this.strategy != null) {
            for (Item item : this.list()) {
                Path path;
                Object d = item.getDockable();
                if (d == null || (path = this.strategy.getPlaceholderFor(d.asDockable())) == null) continue;
                item.add(path);
            }
        }
    }

    public Filter<D> dockables() {
        return this.dockables;
    }

    public Filter<Set<Path>> purePlaceholders() {
        return this.purePlaceholders();
    }

    public Filter<Item> list() {
        return this.allItems;
    }

    public Filter<Set<Path>> listPlaceholders() {
        return this.allPlaceholders;
    }

    public void removeAll(Set<Path> set) {
        Iterator iterator = this.list().iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            item.removeAll(set);
            if (item.getPlaceholderSet() != null || !item.isPlaceholder()) continue;
            iterator.remove();
        }
    }

    public void removeAll(Path path) {
        Iterator iterator = this.list().iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            item.remove(path);
            if (item.getPlaceholderSet() != null || !item.isPlaceholder()) continue;
            iterator.remove();
        }
    }

    public Path remove(int n) {
        Entry entry = this.search(n, Level.DOCKABLE);
        if (entry == null) {
            throw new IllegalArgumentException("no such dockable: " + n);
        }
        return this.removeDockable(entry);
    }

    public Path remove(D d) {
        Entry entry = this.search(d);
        if (entry == null) {
            return null;
        }
        return this.removeDockable(entry);
    }

    private Path removeDockable(Entry entry) {
        Path path;
        Object d = entry.item.getDockable();
        Path path2 = path = this.strategy == null ? null : this.strategy.getPlaceholderFor(d.asDockable());
        if (path == null) {
            if (entry.item.hasPlaceholders()) {
                entry.item.setDockable(null);
            } else {
                entry.remove();
            }
        } else {
            entry.item.add(path);
            entry.item.setDockable(null);
            DockStation dockStation = d.asDockable().asDockStation();
            if (dockStation != null) {
                entry.item.setPlaceholderMap(dockStation.getPlaceholders());
            }
        }
        return path;
    }

    public int put(Path path, D d) {
        Path path2;
        if (d == null) {
            throw new IllegalArgumentException("dockable must not be null");
        }
        Entry entry = this.search(path);
        if (entry == null) {
            return -1;
        }
        entry.set(new Item(this, d, entry.item.getPlaceholderSet(), entry.item.getPlaceholderMap()));
        DockStation dockStation = d.asDockable().asDockStation();
        PlaceholderMap placeholderMap = entry.item.getPlaceholderMap();
        if (dockStation != null && placeholderMap != null) {
            entry.item.setPlaceholderMap(null);
            dockStation.setPlaceholders(placeholderMap);
        }
        this.removeAll(path);
        if (this.strategy != null && (path2 = this.strategy.getPlaceholderFor(d.asDockable())) != null && !path2.equals(path)) {
            this.removeAll(path2);
        }
        return entry.index(Level.DOCKABLE);
    }

    public int getDockableIndex(Path path) {
        Entry entry = this.search(path);
        if (entry == null) {
            return -1;
        }
        while (entry != null && entry.item.isPlaceholder()) {
            entry = entry.previous(Level.BASE);
        }
        if (entry == null) {
            return 0;
        }
        return entry.index(Level.DOCKABLE) + 1;
    }

    public boolean hasPlaceholder(Path path) {
        return this.search(path) != null;
    }

    public boolean put(D d, Path path) {
        Entry entry = this.search(d);
        if (entry == null) {
            return false;
        }
        this.removeAll(path);
        entry.item.add(path);
        return true;
    }

    public D getDockableAt(Path path) {
        Entry entry = this.search(path);
        if (entry == null) {
            return null;
        }
        return entry.item.getDockable();
    }

    public PlaceholderMetaMap getMetaMap(Path path) {
        Entry entry = this.search(path);
        if (entry == null) {
            return null;
        }
        return entry.item;
    }

    private Entry search(Path path) {
        for (Entry entry = this.head; entry != null; entry = entry.next(Level.BASE)) {
            Set<Path> set = entry.item.getPlaceholderSet();
            if (set == null || !set.contains(path)) continue;
            return entry;
        }
        return null;
    }

    private Entry search(D d) {
        for (Entry entry = this.head(Level.DOCKABLE); entry != null; entry = entry.next(Level.DOCKABLE)) {
            if (entry.item.getDockable() != d) continue;
            return entry;
        }
        return null;
    }

    private Entry search(int n, Level level) {
        Entry entry;
        for (entry = this.head(level); entry != null && n > 0; entry = entry.next(level), --n) {
        }
        return entry;
    }

    public int baseToLevel(int n, Level level) {
        Entry entry = this.search(n, Level.BASE);
        if (entry == null) {
            throw new IndexOutOfBoundsException();
        }
        return entry.index(level);
    }

    public int levelToBase(int n, Level level) {
        Entry entry = this.search(n, level);
        if (entry == null) {
            throw new IndexOutOfBoundsException();
        }
        return entry.index(Level.BASE);
    }

    private Entry head(Level level) {
        switch (level) {
            case BASE: {
                return this.head;
            }
            case PLACEHOLDER: {
                return this.headPlaceholder;
            }
            case DOCKABLE: {
                return this.headDockable;
            }
        }
        throw new IllegalArgumentException();
    }

    private void invalidate() {
        this.dockables.invalidate();
        this.allPlaceholders.invalidate();
        this.purePlaceholders.invalidate();
        this.allItems.invalidate();
    }

    public String toString() {
        return this.list().toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class SubList<A>
    implements Filter<A> {
        private Level level;
        private int size = -1;

        protected abstract A unwrap(Item var1);

        protected abstract Item wrap(A var1);

        protected abstract boolean visible(Item var1);

        public SubList(Level level) {
            this.level = level;
        }

        public void invalidate() {
            this.size = -1;
        }

        private Entry getEntry(int n) {
            if (n < 0) {
                throw new IndexOutOfBoundsException();
            }
            Entry entry = PlaceholderList.this.head(this.level);
            while (n > 0) {
                entry = entry.next(this.level);
                --n;
                if (entry != null) continue;
                throw new IndexOutOfBoundsException();
            }
            return entry;
        }

        @Override
        public void add(A a) {
            this.add(this.size(), a);
        }

        @Override
        public void add(int n, A a) {
            if (this.size() == n) {
                Entry entry = PlaceholderList.this.head;
                Entry entry2 = null;
                while (entry != null) {
                    entry2 = entry;
                    entry = entry.next;
                }
                new Entry(entry2, this.wrap(a));
            } else {
                Entry entry = this.getEntry(n);
                new Entry(entry.previous(this.level), this.wrap(a));
            }
        }

        @Override
        public void addPlaceholder(int n, Path path) {
            Entry entry = PlaceholderList.this.search(n, this.level);
            if (entry == null) {
                throw new IndexOutOfBoundsException();
            }
            if (!entry.item.hasPlaceholder(path)) {
                PlaceholderList.this.removeAll(path);
                entry.item.add(path);
            }
        }

        @Override
        public PlaceholderMetaMap getMetaMap(int n) {
            return this.getEntry(n).item;
        }

        @Override
        public A get(int n) {
            return this.unwrap(this.getEntry(n).item);
        }

        @Override
        public int indexOf(A a) {
            int n = 0;
            Entry entry = PlaceholderList.this.head(this.level);
            while (entry != null) {
                if (this.unwrap(entry.item).equals(a)) {
                    return n;
                }
                entry = entry.next(this.level);
                ++n;
            }
            return -1;
        }

        @Override
        public A remove(int n) {
            Entry entry = this.getEntry(n);
            entry.remove();
            return this.unwrap(entry.item);
        }

        @Override
        public int remove(A a) {
            int n = 0;
            Entry entry = PlaceholderList.this.head(this.level);
            while (entry != null) {
                if (this.unwrap(entry.item).equals(a)) {
                    entry.remove();
                    return n;
                }
                entry = entry.next(this.level);
                ++n;
            }
            return -1;
        }

        @Override
        public A set(int n, A a) {
            Entry entry = this.getEntry(n);
            A a2 = this.unwrap(entry.item);
            entry.set(this.wrap(a));
            return a2;
        }

        @Override
        public int size() {
            if (this.size == -1) {
                this.size = 0;
                for (Entry entry = PlaceholderList.this.head(this.level); entry != null; entry = entry.next(this.level)) {
                    ++this.size;
                }
            }
            return this.size;
        }

        @Override
        public void move(int n, int n2) {
            Entry entry = PlaceholderList.this.search(n, this.level);
            if (entry == null) {
                throw new IllegalArgumentException("no entry for index: " + n);
            }
            int n3 = n2 - n;
            entry.move(n3, this.level);
        }

        @Override
        public Iterator<A> iterator() {
            return new Iterator<A>(){
                private Entry current = null;
                private Entry next;
                {
                    this.next = PlaceholderList.this.head(SubList.this.level);
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public A next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    this.current = this.next;
                    this.next = this.next.next(SubList.this.level);
                    return SubList.this.unwrap(this.current.item);
                }

                @Override
                public void remove() {
                    if (this.current == null) {
                        throw new IllegalStateException();
                    }
                    this.current.remove();
                    this.current = null;
                }
            };
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            for (A a : this) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(a);
            }
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Filter<M>
    extends Iterable<M> {
        public int size();

        public M get(int var1);

        public PlaceholderMetaMap getMetaMap(int var1);

        public void add(M var1);

        public void add(int var1, M var2);

        public void addPlaceholder(int var1, Path var2);

        public M set(int var1, M var2);

        public M remove(int var1);

        public int remove(M var1);

        public int indexOf(M var1);

        public void move(int var1, int var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Item
    extends PlaceholderMetaMap {
        private D value;
        private Set<Path> placeholderSet;
        private PlaceholderMap placeholderMap;
        private Entry owner;
        final /* synthetic */ PlaceholderList this$0;

        public Item(D d) {
            this.this$0 = var1_1;
            this.placeholderSet = null;
            if (d == null) {
                throw new IllegalArgumentException("dockable must not be null");
            }
            this.value = d;
        }

        public Item(D d, Set<Path> set, PlaceholderMap placeholderMap) {
            this.this$0 = var1_1;
            this.placeholderSet = null;
            if (d == null) {
                throw new IllegalArgumentException("dockable must not be null");
            }
            this.value = d;
            this.placeholderSet = set;
            this.placeholderMap = placeholderMap;
        }

        public Item(PlaceholderList placeholderList, Set<Path> set) {
            this.this$0 = placeholderList;
            this.placeholderSet = null;
            if (set == null || set.isEmpty()) {
                throw new IllegalArgumentException("placeholder must not be null nor empty");
            }
            this.placeholderSet = set;
        }

        public void setStrategy(PlaceholderStrategy placeholderStrategy) {
            if (this.placeholderMap != null) {
                this.placeholderMap.setPlaceholderStrategy(placeholderStrategy);
            }
        }

        protected void setOwner(Entry entry) {
            if (this.this$0.bound && this.this$0.strategy != null && this.placeholderMap != null) {
                if (entry == null) {
                    this.placeholderMap.setPlaceholderStrategy(null);
                } else {
                    this.placeholderMap.setPlaceholderStrategy(this.this$0.strategy);
                }
            }
            this.owner = entry;
        }

        public boolean isPlaceholder() {
            return this.value == null;
        }

        public Set<Path> getPlaceholderSet() {
            return this.placeholderSet;
        }

        public void setPlaceholderSet(Set<Path> set) {
            this.placeholderSet = set;
        }

        public void removeAll(Set<Path> set) {
            if (this.placeholderSet != null) {
                this.placeholderSet.removeAll(set);
                if (this.placeholderSet.isEmpty()) {
                    this.placeholderSet = null;
                }
            }
            if (this.placeholderMap != null) {
                this.placeholderMap.removeAll(set, true);
                if (this.placeholderMap.isEmpty()) {
                    this.setPlaceholderMap(null);
                }
            }
        }

        public void remove(Path path) {
            if (this.placeholderSet != null) {
                this.placeholderSet.remove(path);
                if (this.placeholderSet.isEmpty()) {
                    this.placeholderSet = null;
                }
            }
            if (this.placeholderMap != null) {
                this.placeholderMap.removeAll(path, true);
                if (this.placeholderMap.isEmpty()) {
                    this.setPlaceholderMap(null);
                }
            }
        }

        public void add(Path path) {
            if (this.placeholderSet == null) {
                this.placeholderSet = new HashSet<Path>();
            }
            this.placeholderSet.add(path);
        }

        public boolean hasPlaceholders() {
            return this.placeholderSet != null && !this.placeholderSet.isEmpty();
        }

        public boolean hasPlaceholder(Path path) {
            return this.placeholderSet != null && this.placeholderSet.contains(path);
        }

        public D getDockable() {
            return this.value;
        }

        public void setDockable(D d) {
            this.value = d;
            this.owner.refresh();
        }

        public void setPlaceholderMap(PlaceholderMap placeholderMap) {
            if (this.this$0.bound && this.this$0.strategy != null) {
                if (this.placeholderMap != null) {
                    this.placeholderMap.setPlaceholderStrategy(null);
                }
                this.placeholderMap = placeholderMap;
                if (this.placeholderMap != null) {
                    this.placeholderMap.setPlaceholderStrategy(this.this$0.strategy);
                }
            } else {
                this.placeholderMap = placeholderMap;
            }
        }

        public PlaceholderMap getPlaceholderMap() {
            return this.placeholderMap;
        }

        public int hashCode() {
            return this.value == null ? 0 : this.value.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object.getClass() == this.getClass()) {
                return this.value == null ? ((Item)object).value == null : this.value.equals(((Item)object).value);
            }
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("(dockable=");
            if (this.value != null) {
                stringBuilder.append(this.value.asDockable().getTitleText());
            }
            stringBuilder.append(", placeholders={");
            if (this.placeholderSet != null) {
                boolean bl = true;
                for (Path path : this.placeholderSet) {
                    if (bl) {
                        bl = false;
                    } else {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(path.toString());
                }
            }
            stringBuilder.append("})");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry {
        private Item item;
        private boolean itemWasPlaceholder;
        private Entry next;
        private Entry previous;
        private Entry nextLevel;
        private Entry previousLevel;

        public Entry(Entry entry, Item item) {
            this.item = item;
            this.insertAfter(entry);
        }

        public void insertAfter(Entry entry) {
            Entry entry2;
            PlaceholderList.this.invalidate();
            this.item.setOwner(this);
            this.itemWasPlaceholder = this.item.isPlaceholder();
            Entry entry3 = null;
            if (entry == null) {
                this.next = PlaceholderList.this.head;
                if (PlaceholderList.this.head != null) {
                    ((PlaceholderList)PlaceholderList.this).head.previous = this;
                }
                PlaceholderList.this.head = this;
                entry3 = null;
            } else {
                this.next = entry.next;
                if (this.next != null) {
                    this.next.previous = this;
                }
                entry.next = this;
                this.previous = entry;
                for (entry2 = entry; entry2 != null && entry3 == null; entry2 = entry2.previous(Level.BASE)) {
                    if (entry2.item.isPlaceholder() != this.item.isPlaceholder()) continue;
                    entry3 = entry2;
                }
            }
            entry2 = null;
            if (entry3 == null) {
                if (this.item.isPlaceholder()) {
                    entry2 = PlaceholderList.this.headPlaceholder;
                    PlaceholderList.this.headPlaceholder = this;
                } else {
                    entry2 = PlaceholderList.this.headDockable;
                    PlaceholderList.this.headDockable = this;
                }
            }
            if (entry3 != null) {
                this.previousLevel = entry3;
                this.nextLevel = entry3.nextLevel;
                if (this.nextLevel != null) {
                    this.nextLevel.previousLevel = this;
                }
                this.previousLevel.nextLevel = this;
            } else if (entry2 != null) {
                this.nextLevel = entry2;
                entry2.previousLevel = this;
            }
        }

        public void move(int n, Level level) {
            if (n == 0) {
                return;
            }
            Entry entry = this;
            if (n > 0) {
                for (int i = 0; i < n; ++i) {
                    if ((entry = entry.next(level)) != null) continue;
                    throw new IllegalArgumentException("delta too big");
                }
            } else {
                for (int i = -n; i >= 0; --i) {
                    if (entry == null) {
                        throw new IllegalArgumentException("delta too big");
                    }
                    entry = entry.previous(level);
                }
            }
            this.remove();
            this.insertAfter(entry);
        }

        public Entry next(Level level) {
            switch (level) {
                case BASE: {
                    return this.next;
                }
                case PLACEHOLDER: {
                    return this.item.isPlaceholder() ? this.nextLevel : null;
                }
                case DOCKABLE: {
                    return this.item.isPlaceholder() ? null : this.nextLevel;
                }
            }
            throw new IllegalArgumentException();
        }

        public Entry previous(Level level) {
            switch (level) {
                case BASE: {
                    return this.previous;
                }
                case PLACEHOLDER: {
                    return this.item.isPlaceholder() ? this.previousLevel : null;
                }
                case DOCKABLE: {
                    return this.item.isPlaceholder() ? null : this.previousLevel;
                }
            }
            throw new IllegalArgumentException();
        }

        public int index(Level level) {
            Entry entry = PlaceholderList.this.head(level);
            int n = 0;
            while (entry != this && entry != null) {
                entry = entry.next(level);
                ++n;
            }
            if (entry == null) {
                return -1;
            }
            return n;
        }

        public void refresh() {
            this.set(this.item);
        }

        public void set(Item item) {
            this.item.setOwner(null);
            item.setOwner(this);
            if (this.itemWasPlaceholder != item.isPlaceholder()) {
                this.itemWasPlaceholder = item.isPlaceholder();
                PlaceholderList.this.invalidate();
                this.removeLevel();
                Entry entry = this.findLevelPredecessor(item.isPlaceholder());
                Entry entry2 = this.findLevelSuccessor(item.isPlaceholder());
                if (entry == null) {
                    if (item.isPlaceholder()) {
                        PlaceholderList.this.headPlaceholder = this;
                    } else {
                        PlaceholderList.this.headDockable = this;
                    }
                    this.previousLevel = null;
                } else {
                    entry.nextLevel = this;
                    this.previousLevel = entry;
                }
                if (entry2 != null) {
                    this.nextLevel = entry2;
                    entry2.previousLevel = this;
                } else {
                    this.nextLevel = null;
                }
            }
            this.item = item;
        }

        private Entry findLevelPredecessor(boolean bl) {
            Entry entry = this.previous;
            while (entry != null) {
                if (entry.item.isPlaceholder() == bl) {
                    return entry;
                }
                entry = entry.previous;
            }
            return null;
        }

        private Entry findLevelSuccessor(boolean bl) {
            Entry entry = this.next;
            while (entry != null) {
                if (entry.item.isPlaceholder() == bl) {
                    return entry;
                }
                entry = entry.next;
            }
            return null;
        }

        public void remove() {
            PlaceholderList.this.invalidate();
            if (this.next != null) {
                this.next.previous = this.previous;
            }
            if (this.previous != null) {
                this.previous.next = this.next;
            }
            if (this == PlaceholderList.this.head) {
                PlaceholderList.this.head = this.next;
            }
            this.next = null;
            this.previous = null;
            this.item.setOwner(null);
            this.removeLevel();
        }

        private void removeLevel() {
            PlaceholderList.this.invalidate();
            if (this.nextLevel != null) {
                this.nextLevel.previousLevel = this.previousLevel;
            }
            if (this.previousLevel != null) {
                this.previousLevel.nextLevel = this.nextLevel;
            }
            if (this == PlaceholderList.this.headDockable) {
                PlaceholderList.this.headDockable = this.nextLevel;
            }
            if (this == PlaceholderList.this.headPlaceholder) {
                PlaceholderList.this.headPlaceholder = this.nextLevel;
            }
            this.nextLevel = null;
            this.previousLevel = null;
        }

        public String toString() {
            return this.item.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Level {
        BASE,
        DOCKABLE,
        PLACEHOLDER;

    }
}

