/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.stack;

import bibliothek.gui.dock.layout.AbstractDockableProperty;
import bibliothek.gui.dock.layout.DockableProperty;
import bibliothek.util.Path;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class StackDockProperty
extends AbstractDockableProperty {
    public static final StackDockProperty FRONT = new StackDockProperty(0);
    public static final StackDockProperty BACK = new StackDockProperty(Integer.MAX_VALUE);
    private int index;
    private Path placeholder;

    public StackDockProperty(int n) {
        this.setIndex(n);
    }

    public StackDockProperty(int n, Path path) {
        this.setIndex(n);
        this.setPlaceholder(path);
    }

    public StackDockProperty() {
    }

    public DockableProperty copy() {
        StackDockProperty stackDockProperty = new StackDockProperty(this.index);
        this.copy(stackDockProperty);
        return stackDockProperty;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public int getIndex() {
        return this.index;
    }

    public void setPlaceholder(Path path) {
        this.placeholder = path;
    }

    public Path getPlaceholder() {
        return this.placeholder;
    }

    public String getFactoryID() {
        return "StackDockPropertyFactory";
    }

    public void store(DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_8);
        dataOutputStream.writeInt(this.index);
        if (this.placeholder == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            dataOutputStream.writeUTF(this.placeholder.toString());
        }
    }

    public void store(XElement xElement) {
        if (this.index >= 0) {
            xElement.addElement("index").setInt(this.index);
        }
        if (this.placeholder != null) {
            xElement.addElement("placeholder").setString(this.placeholder.toString());
        }
    }

    public void load(DataInputStream dataInputStream) throws IOException {
        Version version = Version.read(dataInputStream);
        version.checkCurrent();
        boolean bl = Version.VERSION_1_0_8.compareTo(version) <= 0;
        this.index = dataInputStream.readInt();
        this.placeholder = null;
        if (bl && dataInputStream.readBoolean()) {
            this.placeholder = new Path(dataInputStream.readUTF());
        }
    }

    public void load(XElement xElement) {
        this.index = -1;
        this.placeholder = null;
        XElement xElement2 = xElement.getElement("index");
        XElement xElement3 = xElement.getElement("placeholder");
        if (xElement2 == null && xElement3 == null) {
            if (xElement.getValue() != null && xElement.getValue().length() > 0) {
                this.index = xElement.getInt();
            }
        } else {
            if (xElement2 != null) {
                this.index = xElement2.getInt();
            }
            if (xElement3 != null) {
                this.placeholder = new Path(xElement3.getString());
            }
        }
    }

    public int hashCode() {
        int n = super.hashCode();
        n = 31 * n + this.index;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (!(object instanceof StackDockProperty)) {
            return false;
        }
        StackDockProperty stackDockProperty = (StackDockProperty)object;
        return this.index == stackDockProperty.index;
    }
}

