/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.event;

import bibliothek.gui.DockFrontend;
import bibliothek.gui.Dockable;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VetoableDockFrontendEvent
implements Iterable<Dockable> {
    private DockFrontend frontend;
    private Dockable[] dockables;
    private boolean cancelable;
    private boolean canceled = false;
    private boolean expected;

    public VetoableDockFrontendEvent(DockFrontend dockFrontend, boolean bl, boolean bl2, Dockable ... dockableArray) {
        if (dockableArray.length < 1) {
            throw new IllegalArgumentException("An empty event is not allowed");
        }
        this.frontend = dockFrontend;
        this.dockables = dockableArray;
        this.cancelable = bl;
        this.expected = bl2;
    }

    public DockFrontend getFrontend() {
        return this.frontend;
    }

    public int getDockableCount() {
        return this.dockables.length;
    }

    public Dockable getDockable(int n) {
        return this.dockables[n];
    }

    public Dockable[] getDockables() {
        Dockable[] dockableArray = new Dockable[this.dockables.length];
        System.arraycopy(this.dockables, 0, dockableArray, 0, this.dockables.length);
        return dockableArray;
    }

    @Override
    public Iterator<Dockable> iterator() {
        return new Iterator<Dockable>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < VetoableDockFrontendEvent.this.dockables.length;
            }

            @Override
            public Dockable next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return VetoableDockFrontendEvent.this.dockables[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean isCancelable() {
        return this.cancelable;
    }

    public void cancel() {
        if (this.cancelable) {
            this.canceled = true;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public boolean isExpected() {
        return this.expected;
    }
}

