/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control.relocator;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.control.relocator.Merger;
import bibliothek.gui.dock.control.relocator.RelocateOperation;
import bibliothek.gui.dock.event.DockRelocatorListener;

public class MergeOperation
implements RelocateOperation {
    private DockController controller;
    private Merger merger;
    private DockStation station;

    public MergeOperation(DockController dockController, Merger merger, DockStation dockStation) {
        this.controller = dockController;
        this.merger = merger;
        this.station = dockStation;
    }

    public DockStation getStation() {
        return this.station;
    }

    public void execute(Dockable dockable, DockRelocatorListener dockRelocatorListener) {
        DockStation dockStation = dockable.asDockStation();
        Dockable[] dockableArray = new Dockable[dockStation.getDockableCount()];
        for (int i = 0; i < dockableArray.length; ++i) {
            dockableArray[i] = dockStation.getDockable(i);
            dockRelocatorListener.drag(this.controller, dockableArray[i], dockStation);
        }
        this.merger.merge(this.station, dockStation);
        for (Dockable dockable2 : dockableArray) {
            dockRelocatorListener.drop(this.controller, dockable2, this.station);
        }
        DockStation dockStation2 = dockable.getDockParent();
        if (dockStation2 != null) {
            dockStation2.drag(dockable);
        }
    }
}

