/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

public class ModifierMask {
    public static int KEY_MASK = 9152;
    private int onmask;
    private int offmask;

    public ModifierMask(int n) {
        this(n, ~n);
    }

    public ModifierMask(int n, int n2) {
        this.onmask = n & KEY_MASK;
        this.offmask = n2 & KEY_MASK;
    }

    public String onMaskToString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.put(stringBuilder, 512, "alt");
        this.put(stringBuilder, 8192, "alt graph");
        this.put(stringBuilder, 128, "ctrl");
        this.put(stringBuilder, 256, "meta");
        this.put(stringBuilder, 64, "shift");
        return stringBuilder.toString();
    }

    private void put(StringBuilder stringBuilder, int n, String string) {
        if ((this.onmask & n) == n) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append(string);
        }
    }

    public boolean matches(int n) {
        return (n & (this.onmask | this.offmask)) == this.onmask;
    }

    public void setOnmask(int n) {
        this.onmask = n & KEY_MASK;
    }

    public int getOnmask() {
        return this.onmask;
    }

    public void setOffmask(int n) {
        this.offmask = n & KEY_MASK;
    }

    public int getOffmask() {
        return this.offmask;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.offmask;
        n = 31 * n + this.onmask;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ModifierMask modifierMask = (ModifierMask)object;
        if (this.offmask != modifierMask.offmask) {
            return false;
        }
        return this.onmask == modifierMask.onmask;
    }
}

