/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.control;

import bibliothek.gui.DockController;
import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.event.DockRegisterListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.util.DockUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DockRegister {
    private List<DockStation> stations = new ArrayList<DockStation>();
    private List<Dockable> dockables = new ArrayList<Dockable>();
    private DockController controller;
    private List<DockRegisterListener> registerListeners = new ArrayList<DockRegisterListener>();
    private StationListener stationListener = new StationListener();
    private int stalled = 0;

    public DockRegister(DockController dockController) {
        if (dockController == null) {
            throw new IllegalArgumentException("controller must not be null");
        }
        this.controller = dockController;
    }

    public DockController getController() {
        return this.controller;
    }

    public void addDockRegisterListener(DockRegisterListener dockRegisterListener) {
        this.registerListeners.add(dockRegisterListener);
    }

    public void removeDockRegisterListener(DockRegisterListener dockRegisterListener) {
        this.registerListeners.remove(dockRegisterListener);
    }

    public void kill() {
        ArrayList<DockStation> arrayList = new ArrayList<DockStation>(this.stations);
        for (DockStation dockStation : arrayList) {
            this.remove(dockStation);
        }
    }

    public void add(DockStation dockStation) {
        this.add(dockStation, true);
    }

    private void add(DockStation dockStation, final boolean bl) {
        if (dockStation == null) {
            throw new NullPointerException("Station must not be null");
        }
        if (!this.stations.contains(dockStation)) {
            DockController dockController = dockStation.getController();
            if (dockController != null && dockController != this.controller) {
                dockController.getRegister().remove(dockStation);
            }
            DockUtilities.visit(dockStation, new DockUtilities.DockVisitor(){

                public void handleDockable(Dockable dockable) {
                    DockRegister.this.register(dockable);
                }

                public void handleDockStation(DockStation dockStation) {
                    DockRegister.this.register(dockStation, bl);
                }
            });
        }
    }

    public void remove(DockStation dockStation) {
        if (this.stations.contains(dockStation)) {
            DockStation dockStation2;
            Dockable dockable = dockStation.asDockable();
            if (dockable != null && (dockStation2 = dockable.getDockParent()) != null) {
                dockStation2.drag(dockable);
            }
            DockUtilities.visit(dockStation, new DockUtilities.DockVisitor(){

                public void handleDockable(Dockable dockable) {
                    DockRegister.this.unregister(dockable);
                }

                public void handleDockStation(DockStation dockStation) {
                    DockRegister.this.unregister(dockStation);
                }
            });
        }
    }

    public int getStationCount() {
        return this.stations.size();
    }

    public DockStation getStation(int n) {
        return this.stations.get(n);
    }

    public DockStation[] listDockStations() {
        return this.stations.toArray(new DockStation[this.stations.size()]);
    }

    public DockStation[] listRoots() {
        LinkedList<DockStation> linkedList = new LinkedList<DockStation>();
        for (DockStation dockStation : this.stations) {
            Dockable dockable = dockStation.asDockable();
            if (dockable != null && dockable.getDockParent() != null) continue;
            linkedList.add(dockStation);
        }
        return linkedList.toArray(new DockStation[linkedList.size()]);
    }

    public int getDockableCount() {
        return this.dockables.size();
    }

    public Dockable getDockable(int n) {
        return this.dockables.get(n);
    }

    public Dockable[] listDockables() {
        return this.dockables.toArray(new Dockable[this.dockables.size()]);
    }

    protected void register(Dockable dockable) {
        if (!this.dockables.contains(dockable)) {
            this.fireDockableRegistering(dockable);
            this.dockables.add(dockable);
            dockable.setController(this.controller);
            this.fireDockableRegistered(dockable);
        }
    }

    protected void unregister(Dockable dockable) {
        if (this.dockables.remove(dockable)) {
            dockable.setController(null);
            this.fireDockableUnregistered(dockable);
        }
    }

    protected void register(DockStation dockStation, boolean bl) {
        if (!this.stations.contains(dockStation)) {
            this.fireDockStationRegistering(dockStation);
            this.stations.add(dockStation);
            dockStation.setController(this.controller);
            dockStation.updateTheme();
            if (bl) {
                dockStation.addDockStationListener(this.stationListener);
            }
            this.fireDockStationRegistered(dockStation);
        }
    }

    protected void unregister(DockStation dockStation) {
        if (this.stations.remove(dockStation)) {
            dockStation.setController(null);
            dockStation.removeDockStationListener(this.stationListener);
            this.fireDockStationUnregistered(dockStation);
        }
    }

    protected DockRegisterListener[] listDockRegisterListeners() {
        return this.registerListeners.toArray(new DockRegisterListener[this.registerListeners.size()]);
    }

    protected void fireDockableRegistering(Dockable dockable) {
        for (DockRegisterListener dockRegisterListener : this.listDockRegisterListeners()) {
            dockRegisterListener.dockableRegistering(this.controller, dockable);
        }
    }

    protected void fireDockableRegistered(Dockable dockable) {
        for (DockRegisterListener dockRegisterListener : this.listDockRegisterListeners()) {
            dockRegisterListener.dockableRegistered(this.controller, dockable);
        }
    }

    protected void fireDockableUnregistered(Dockable dockable) {
        for (DockRegisterListener dockRegisterListener : this.listDockRegisterListeners()) {
            dockRegisterListener.dockableUnregistered(this.controller, dockable);
        }
    }

    protected void fireDockStationRegistering(DockStation dockStation) {
        for (DockRegisterListener dockRegisterListener : this.listDockRegisterListeners()) {
            dockRegisterListener.dockStationRegistering(this.controller, dockStation);
        }
    }

    protected void fireDockStationRegistered(DockStation dockStation) {
        for (DockRegisterListener dockRegisterListener : this.listDockRegisterListeners()) {
            dockRegisterListener.dockStationRegistered(this.controller, dockStation);
        }
    }

    protected void fireDockStationUnregistered(DockStation dockStation) {
        for (DockRegisterListener dockRegisterListener : this.listDockRegisterListeners()) {
            dockRegisterListener.dockStationUnregistered(this.controller, dockStation);
        }
    }

    protected void fireStalledChange(Dockable dockable) {
        for (DockRegisterListener dockRegisterListener : this.listDockRegisterListeners()) {
            dockRegisterListener.dockableCycledRegister(this.controller, dockable);
        }
    }

    public void setStalled(boolean bl) {
        this.stalled = bl ? ++this.stalled : --this.stalled;
        if (this.stalled < 0) {
            this.stalled = 0;
        }
        if (this.stalled == 0) {
            this.stationListener.fire();
        }
    }

    public boolean isStalled() {
        return this.stalled > 0;
    }

    private class StationListener
    extends DockStationAdapter {
        private Map<Dockable, Status> changeMap = new HashMap<Dockable, Status>();
        private LinkedList<Dockable> changeQueue = new LinkedList();
        private boolean firing = false;

        private StationListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void fire() {
            if (!this.firing) {
                try {
                    this.firing = true;
                    while (!this.changeQueue.isEmpty()) {
                        Dockable dockable = this.changeQueue.removeFirst();
                        Status status = this.changeMap.remove(dockable);
                        switch (status) {
                            case ADDED: {
                                this.addDockable(dockable, false);
                                break;
                            }
                            case REMOVED: {
                                this.removeDockable(dockable);
                                break;
                            }
                            case ADDED_AND_REMOVED: 
                            case REMOVED_AND_ADDED: {
                                DockRegister.this.fireStalledChange(dockable);
                            }
                        }
                    }
                }
                finally {
                    this.firing = false;
                }
            }
        }

        public void dockableAdding(DockStation dockStation, Dockable dockable) {
            if (DockRegister.this.stalled > 0) {
                DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

                    public void handleDockable(Dockable dockable) {
                        Status status = (Status)((Object)StationListener.this.changeMap.get(dockable));
                        if (status == null) {
                            StationListener.this.changeMap.put(dockable, Status.ADDED);
                            StationListener.this.changeQueue.add(dockable);
                        } else {
                            switch (status) {
                                case REMOVED: {
                                    StationListener.this.changeMap.put(dockable, Status.REMOVED_AND_ADDED);
                                    break;
                                }
                                case ADDED_AND_REMOVED: {
                                    StationListener.this.changeMap.put(dockable, Status.ADDED);
                                }
                            }
                        }
                    }

                    public void handleDockStation(DockStation dockStation) {
                        dockStation.addDockStationListener(StationListener.this);
                    }
                });
            } else {
                this.addDockable(dockable, true);
            }
        }

        private void addDockable(Dockable dockable, boolean bl) {
            DockStation dockStation = dockable.asDockStation();
            if (dockStation != null) {
                DockRegister.this.add(dockStation, bl);
            } else {
                DockRegister.this.register(dockable);
            }
        }

        public void dockableRemoving(DockStation dockStation, Dockable dockable) {
            if (DockRegister.this.stalled > 0) {
                DockUtilities.visit(dockable, new DockUtilities.DockVisitor(){

                    public void handleDockable(Dockable dockable) {
                        Status status = (Status)((Object)StationListener.this.changeMap.get(dockable));
                        if (status == null) {
                            StationListener.this.changeMap.put(dockable, Status.REMOVED);
                            StationListener.this.changeQueue.add(dockable);
                        } else {
                            switch (status) {
                                case ADDED: {
                                    StationListener.this.changeMap.put(dockable, Status.ADDED_AND_REMOVED);
                                    break;
                                }
                                case REMOVED_AND_ADDED: {
                                    StationListener.this.changeMap.put(dockable, Status.REMOVED);
                                }
                            }
                        }
                    }
                });
            }
        }

        public void dockableRemoved(DockStation dockStation, Dockable dockable) {
            dockable.setDockParent(null);
            DockStation dockStation2 = dockable.asDockStation();
            if (dockStation2 != null) {
                dockStation2.removeDockStationListener(this);
            }
            if (DockRegister.this.stalled == 0) {
                this.removeDockable(dockable);
            }
        }

        private void removeDockable(Dockable dockable) {
            DockStation dockStation = dockable.asDockStation();
            if (dockStation != null) {
                DockRegister.this.remove(dockStation);
            } else {
                DockRegister.this.unregister(dockable);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        ADDED,
        REMOVED,
        ADDED_AND_REMOVED,
        REMOVED_AND_ADDED;

    }
}

