/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action.dropdown;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DropDownAction;
import bibliothek.gui.dock.action.dropdown.AbstractDropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilter;
import bibliothek.gui.dock.action.dropdown.DropDownFilterFactory;
import bibliothek.gui.dock.action.dropdown.DropDownView;
import bibliothek.gui.dock.themes.basic.action.dropdown.DropDownViewItem;

public class DefaultDropDownFilter
extends AbstractDropDownFilter {
    public static final DropDownFilterFactory FACTORY = new DropDownFilterFactory(){

        public DropDownFilter createView(DropDownAction dropDownAction, Dockable dockable, DropDownView dropDownView) {
            return new DefaultDropDownFilter(dropDownAction, dockable, dropDownView);
        }
    };

    public DefaultDropDownFilter(DropDownAction dropDownAction, Dockable dockable, DropDownView dropDownView) {
        super(dropDownAction, dockable, dropDownView);
    }

    public void update(DropDownViewItem dropDownViewItem) {
        this.updateEnabled(dropDownViewItem);
        this.updateSelected(dropDownViewItem);
        this.updateIcon(dropDownViewItem);
        this.updateDisabledIcon(dropDownViewItem);
        this.updateText(dropDownViewItem);
        this.updateTooltip(dropDownViewItem);
    }

    protected void updateEnabled(DropDownViewItem dropDownViewItem) {
        this.getView().setEnabled(this.enabled);
    }

    protected void updateSelected(DropDownViewItem dropDownViewItem) {
        this.getView().setSelected(this.selected);
    }

    protected void updateIcon(DropDownViewItem dropDownViewItem) {
        if (this.icon == null) {
            this.getView().setIcon(this.getAction().getIcon(this.getDockable()));
        } else {
            this.getView().setIcon(this.icon);
        }
    }

    protected void updateDisabledIcon(DropDownViewItem dropDownViewItem) {
        if (this.disabledIcon == null) {
            this.getView().setDisabledIcon(this.getAction().getDisabledIcon(this.getDockable()));
        } else {
            this.getView().setDisabledIcon(this.disabledIcon);
        }
    }

    protected void updateText(DropDownViewItem dropDownViewItem) {
        if (this.text == null) {
            this.getView().setText(this.getAction().getText(this.getDockable()));
        } else {
            this.getView().setText(null);
        }
    }

    protected void updateTooltip(DropDownViewItem dropDownViewItem) {
        if (dropDownViewItem == null || !dropDownViewItem.isTriggerable(true)) {
            String string = this.getAction().getTooltipText(this.getDockable());
            if (string == null) {
                string = this.tooltip;
            }
            if (string == null) {
                string = this.getAction().getText(this.getDockable());
            }
            if (string == null) {
                string = this.text;
            }
            this.getView().setTooltip(string);
        } else {
            String string = this.tooltip;
            if (string == null) {
                string = this.getAction().getTooltipText(this.getDockable());
            }
            if (string == null) {
                string = this.text;
            }
            if (string == null) {
                string = this.getAction().getText(this.getDockable());
            }
            this.getView().setTooltip(string);
        }
    }
}

