/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse.stack.tab;

import java.util.Arrays;

public class Arch {
    private int width;
    private int height;
    private int[] values;

    public Arch(int n, int n2) {
        if (n < 1 || n2 < 1) {
            throw new IllegalArgumentException("width or height smaller than 1: " + n + ", " + n2);
        }
        this.width = n;
        this.height = n2;
        this.values = new int[n];
        this.calculate();
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getValue(int n) {
        return this.values[n];
    }

    private void calculate() {
        int n;
        int n2;
        int n3 = this.lineH(this.width);
        int n4 = this.lineV(this.height);
        int n5 = (this.width - n3) / 2;
        int n6 = (this.height - n4) / 2;
        Arrays.fill(this.values, -1);
        double[] dArray = this.arch(0, 0, n5, n6, (double)n4 / (double)n3);
        for (n2 = 0; n2 < n5; ++n2) {
            this.values[n2] = n = (int)(dArray[n2] + 0.5);
            this.values[this.width - 1 - n2] = this.height - 1 - n;
        }
        dArray = this.line(n5, n6, n5 + n3 / 2 - 1, n6 + n4 / 2 - 1);
        for (n2 = 0; n2 < dArray.length; ++n2) {
            this.values[n2 + n5] = n = (int)(dArray[n2] + 0.5);
            this.values[this.width - 1 - n2 - n5] = this.height - 1 - n;
        }
        if (this.values[0] == -1) {
            this.values[0] = 0;
            this.values[this.values.length - 1] = this.height - 1;
        }
        n = this.width / 2;
        for (n2 = 1; n2 <= n; ++n2) {
            if (this.values[n2] != -1) continue;
            this.values[n2] = this.values[n2 - 1];
            this.values[this.width - n2 - 1] = this.values[this.width - n2];
        }
    }

    private double[] line(int n, int n2, int n3, int n4) {
        double[] dArray = new double[n3 - n + 1];
        for (int i = 0; i < dArray.length; ++i) {
            for (int j = 0; j < 10; ++j) {
                double d = (double)(10 * i + j) / 10.0 / (double)dArray.length;
                double d2 = (double)n + d * (double)(n3 - n + 1);
                double d3 = (double)n2 + d * (double)(n4 - n2 + 1);
                int n5 = (int)d2 - n;
                dArray[n5] = dArray[n5] + 0.1 * d3;
            }
        }
        return dArray;
    }

    private double[] arch(int n, int n2, int n3, int n4, double d) {
        double d2 = n2;
        double d3 = this.cutWithZero(n + n3, n2 + n4, d, d2);
        double d4 = d2;
        double d5 = Math.tan(Math.PI - Math.atan(d) / 2.0);
        double d6 = d4 - d5 * d3;
        double d7 = -0.6;
        d4 = d5 * (d3 += d7) + d6;
        double[] dArray = new double[n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < 10; ++j) {
                double d8 = (double)(10 * i + j) / 10.0 / (double)n3;
                double d9 = this.bezier(d8, n, d3, n + n3);
                double d10 = this.bezier(d8, n2, d4, n2 + n4);
                int n5 = (int)d9 - n;
                dArray[n5] = dArray[n5] + 0.1 * d10;
            }
        }
        return dArray;
    }

    private double bezier(double d, double d2, double d3, double d4) {
        return (1.0 - d) * (1.0 - d) * d2 + 2.0 * d * (1.0 - d) * d3 + d * d * d4;
    }

    private double cutWithZero(double d, double d2, double d3, double d4) {
        double d5 = d2 - d3 * d;
        return (d4 - d5) / d3;
    }

    private int lineH(int n) {
        int n2 = n / 3;
        int n3 = n % 3;
        if (n3 == 1) {
            return n2 + 1;
        }
        return n2;
    }

    private int lineV(int n) {
        int n2 = n / 2;
        if ((n - n2) % 2 == 1) {
            ++n2;
        }
        return n2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.height; ++i) {
            if (i > 0) {
                stringBuilder.append("\n");
            }
            if (i < 10) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(i);
            stringBuilder.append(": ");
            for (int j = 0; j < this.width; ++j) {
                if (this.values[j] == i) {
                    stringBuilder.append("*");
                    continue;
                }
                stringBuilder.append(" ");
            }
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + this.height;
        n = 31 * n + this.width;
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Arch arch = (Arch)object;
        if (this.height != arch.height) {
            return false;
        }
        return this.width == arch.width;
    }
}

