/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.preference;

import bibliothek.extension.gui.dock.preference.PreferenceModel;
import bibliothek.gui.DockUI;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPreferenceDialog<M extends PreferenceModel>
extends JPanel {
    private M model;
    private JComponent content;
    private JDialog dialog;

    public AbstractPreferenceDialog() {
        this(null);
    }

    public AbstractPreferenceDialog(M m) {
        this.init(m);
    }

    protected AbstractPreferenceDialog(boolean bl, M m) {
        if (bl) {
            this.init(null);
        }
    }

    protected void init(M m) {
        if (this.content != null) {
            throw new IllegalStateException("Already initialized");
        }
        this.setLayout(new GridBagLayout());
        this.model = m;
        this.content = this.getContent();
        this.setModelForContent(m);
        JPanel jPanel = new JPanel(new GridLayout(1, 4));
        jPanel.add(new JButton(new ApplyAction()));
        jPanel.add(new JButton(new ResetAction()));
        jPanel.add(new JButton(new OkAction()));
        jPanel.add(new JButton(new CancelAction()));
        this.add((Component)this.content, new GridBagConstraints(0, 0, 1, 1, 1.0, 1000.0, 10, 1, new Insets(1, 1, 1, 1), 0, 0));
        this.add((Component)jPanel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 26, 0, new Insets(1, 1, 1, 1), 0, 0));
    }

    protected abstract JComponent getContent();

    protected abstract void setModelForContent(M var1);

    public void setModel(M m) {
        this.model = m;
        this.setModelForContent(m);
    }

    public M getModel() {
        return this.model;
    }

    public void openDialog(Component component, boolean bl) {
        if (this.dialog != null) {
            return;
        }
        this.dialog = this.createDialog(component);
        this.dialog.setModal(bl);
        this.dialog.add(this);
        this.doReset();
        this.dialog.pack();
        this.dialog.setSize((int)((double)this.dialog.getWidth() * 1.5), this.dialog.getHeight());
        this.dialog.setLocationRelativeTo(component);
        this.dialog.setVisible(true);
    }

    private JDialog createDialog(Component component) {
        Window window;
        JDialog jDialog = component == null ? new JDialog() : ((window = SwingUtilities.getWindowAncestor(component)) instanceof Frame ? new JDialog((Frame)window) : (window instanceof Dialog ? new JDialog((Dialog)window) : new JDialog()));
        jDialog.setTitle(DockUI.getDefaultDockUI().getString("preference.dialog.title"));
        jDialog.setDefaultCloseOperation(0);
        jDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AbstractPreferenceDialog.this.doCancel();
            }
        });
        return jDialog;
    }

    public void doOk() {
        this.doApply();
        this.close();
    }

    public void doApply() {
        this.getModel().write();
    }

    public void doCancel() {
        this.doReset();
        this.close();
    }

    public void doReset() {
        this.getModel().read();
    }

    public void close() {
        if (this.dialog != null) {
            this.dialog.dispose();
            this.dialog.remove(this);
            this.dialog = null;
        }
    }

    private class ResetAction
    extends AbstractAction {
        public ResetAction() {
            this.putValue("Name", DockUI.getDefaultDockUI().getString("preference.dialog.reset.text"));
            this.putValue("ShortDescription", DockUI.getDefaultDockUI().getString("preference.dialog.reset.description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPreferenceDialog.this.doReset();
        }
    }

    private class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", DockUI.getDefaultDockUI().getString("preference.dialog.cancel.text"));
            this.putValue("ShortDescription", DockUI.getDefaultDockUI().getString("preference.dialog.cancel.description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPreferenceDialog.this.doCancel();
        }
    }

    private class ApplyAction
    extends AbstractAction {
        public ApplyAction() {
            this.putValue("Name", DockUI.getDefaultDockUI().getString("preference.dialog.apply.text"));
            this.putValue("ShortDescription", DockUI.getDefaultDockUI().getString("preference.dialog.apply.description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPreferenceDialog.this.doApply();
        }
    }

    private class OkAction
    extends AbstractAction {
        public OkAction() {
            this.putValue("Name", DockUI.getDefaultDockUI().getString("preference.dialog.ok.text"));
            this.putValue("ShortDescription", DockUI.getDefaultDockUI().getString("preference.dialog.ok.description"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractPreferenceDialog.this.doOk();
        }
    }
}

