/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.dock.support.menu.MenuPiece;
import bibliothek.gui.dock.support.menu.MenuPieceListener;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeMenuPiece
extends MenuPiece {
    private List<MenuPiece> children = new ArrayList<MenuPiece>();
    private Listener listener = new Listener();

    public void add(MenuPiece menuPiece) {
        this.insert(this.children.size(), menuPiece);
    }

    public void insert(int n, MenuPiece menuPiece) {
        if (menuPiece.getParent() != null) {
            throw new IllegalArgumentException("piece already has a parent");
        }
        menuPiece.setParent(this);
        this.children.add(n, menuPiece);
        menuPiece.addListener(this.listener);
        this.listener.insert(menuPiece, 0, menuPiece.items());
    }

    public void remove(MenuPiece menuPiece) {
        if (this.children.contains(menuPiece)) {
            this.listener.remove(menuPiece, 0, menuPiece.getItemCount());
            menuPiece.removeListener(this.listener);
            menuPiece.setParent(null);
            this.children.remove(menuPiece);
        }
    }

    public void remove(int n) {
        MenuPiece menuPiece = this.children.get(n);
        this.listener.remove(menuPiece, 0, menuPiece.getItemCount());
        menuPiece.removeListener(this.listener);
        menuPiece.setParent(null);
        this.children.remove(n);
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public MenuPiece getChild(int n) {
        return this.children.get(n);
    }

    @Override
    public void fill(List<Component> list) {
        for (MenuPiece menuPiece : this.children) {
            menuPiece.fill(list);
        }
    }

    @Override
    public int getItemCount() {
        int n = 0;
        for (MenuPiece menuPiece : this.children) {
            n += menuPiece.getItemCount();
        }
        return n;
    }

    private class Listener
    implements MenuPieceListener {
        private Listener() {
        }

        public void insert(MenuPiece menuPiece, int n, Component ... componentArray) {
            MenuPiece menuPiece2;
            Iterator iterator = NodeMenuPiece.this.children.iterator();
            while (iterator.hasNext() && (menuPiece2 = (MenuPiece)iterator.next()) != menuPiece) {
                n += menuPiece2.getItemCount();
            }
            NodeMenuPiece.this.fireInsert(n, componentArray);
        }

        public void remove(MenuPiece menuPiece, int n, int n2) {
            MenuPiece menuPiece2;
            Iterator iterator = NodeMenuPiece.this.children.iterator();
            while (iterator.hasNext() && (menuPiece2 = (MenuPiece)iterator.next()) != menuPiece) {
                n += menuPiece2.getItemCount();
            }
            NodeMenuPiece.this.fireRemove(n, n2);
        }
    }
}

