/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.intern;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.DockFactory;
import bibliothek.gui.dock.common.CControl;
import bibliothek.gui.dock.common.SingleCDockable;
import bibliothek.gui.dock.common.SingleCDockableBackupFactory;
import bibliothek.gui.dock.common.intern.CDockable;
import bibliothek.gui.dock.common.intern.CommonDockable;
import bibliothek.gui.dock.layout.LocationEstimationMap;
import bibliothek.gui.dock.station.support.PlaceholderStrategy;
import bibliothek.util.Version;
import bibliothek.util.xml.XElement;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonSingleDockableFactory
implements DockFactory<CommonDockable, String> {
    public static final String BACKUP_FACTORY_ID = "ccontrol backup factory id";
    private Map<String, SingleCDockableBackupFactory> backups = new HashMap<String, SingleCDockableBackupFactory>();
    private CControl control;

    public CommonSingleDockableFactory(CControl cControl) {
        this.control = cControl;
    }

    public void add(String string, SingleCDockableBackupFactory singleCDockableBackupFactory) {
        this.backups.put(string, singleCDockableBackupFactory);
    }

    public void remove(String string) {
        this.backups.remove(string);
    }

    public SingleCDockableBackupFactory getFactory(String string) {
        return this.backups.get(string);
    }

    @Override
    public String getID() {
        return BACKUP_FACTORY_ID;
    }

    public String[] listFactories() {
        Set<String> set = this.backups.keySet();
        return set.toArray(new String[set.size()]);
    }

    public Set<String> getFactoryIds() {
        return Collections.unmodifiableSet(this.backups.keySet());
    }

    @Override
    public void estimateLocations(String string, LocationEstimationMap locationEstimationMap) {
    }

    @Override
    public String getLayout(CommonDockable commonDockable, Map<Dockable, Integer> map) {
        CDockable cDockable = commonDockable.getDockable();
        if (cDockable instanceof SingleCDockable) {
            SingleCDockable singleCDockable = (SingleCDockable)cDockable;
            return singleCDockable.getUniqueId();
        }
        throw new IllegalArgumentException("A CommonSingleDockableFactory works only with Dockables of type SingleCDockable, but this is not a single dockable: " + commonDockable);
    }

    @Override
    public CommonDockable layout(String string, Map<Integer, Dockable> map) {
        return this.layout(string);
    }

    @Override
    public CommonDockable layout(String string) {
        SingleCDockableBackupFactory singleCDockableBackupFactory = this.backups.get(string);
        if (singleCDockableBackupFactory == null) {
            return null;
        }
        SingleCDockable singleCDockable = singleCDockableBackupFactory.createBackup(string);
        if (singleCDockable == null) {
            return null;
        }
        this.control.add(singleCDockable);
        return singleCDockable.intern();
    }

    @Override
    public String read(DataInputStream dataInputStream, PlaceholderStrategy placeholderStrategy) throws IOException {
        Version version = Version.read(dataInputStream);
        if (!version.equals(Version.VERSION_1_0_4)) {
            throw new IOException("Data from the future - unknown version: " + version);
        }
        return dataInputStream.readUTF();
    }

    @Override
    public String read(XElement xElement, PlaceholderStrategy placeholderStrategy) {
        return xElement.getElement("id").getString();
    }

    @Override
    public void setLayout(CommonDockable commonDockable, String string, Map<Integer, Dockable> map) {
    }

    @Override
    public void setLayout(CommonDockable commonDockable, String string) {
    }

    @Override
    public void write(String string, DataOutputStream dataOutputStream) throws IOException {
        Version.write(dataOutputStream, Version.VERSION_1_0_4);
        dataOutputStream.writeUTF(string);
    }

    @Override
    public void write(String string, XElement xElement) {
        xElement.addElement("id").setString(string);
    }
}

