% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/speech_recompiler.R
\name{speech_recompiler}
\alias{speech_recompiler}
\title{Speech recompiler}
\usage{
speech_recompiler(
  tidy_speech,
  compiler_by = c("legislator", "party", "legislature", "chamber")
)
}
\arguments{
\item{tidy_speech}{data.frame.}

\item{compiler_by}{character vector. Variables for which you may want to recompile the data frame.}
}
\value{
data.frame.
}
\description{
It allows to recompile an object of the \code{puy} class, the datasets
    speech or a data.frame built with \code{speech_build} to which the
    variable political party was added.
}
\details{
The default compilation is that of \ code {speech_build (., compiler = TRUE}).
    This function allows to recompile the data by different levels of aggregation:
    chamber, legislature or other variables.
}
\examples{
\donttest{
url <- "http://bit.ly/35AUVF4"
out <- speech_build(file = url)
out2 <- speech_recompiler(out)
out2 <- speech_recompiler(out, compiler_by = c("legislator", "legislature", "chamber"))
}
}
