% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Spectra-methods.R
\docType{methods}
\name{cut}
\alias{cut}
\alias{cut,Spectra-method}
\title{Manipulating the wavelength range of a \code{Spectra} object}
\usage{
\S4method{cut}{Spectra}(x, ..., wl)
}
\arguments{
\item{x}{an object inheriting from class \code{Spectra}}

\item{...}{ignored}

\item{wl}{a vector of the wavelengths to either select or remove from
\code{x}}
}
\value{
An object of the same class as \code{x}.
}
\description{
This methods allows to either select or remove a specific range of
wavelengths from a \code{Spectra} object.
}
\details{
The wavelengths are extracted if \code{wl > 0}, or removed if \code{wl < 0}.
You can't mix negative and positive index in \code{wl}.
}
\examples{

# Loading example data
data(australia)
spectra(australia) <- sr_no ~ ... ~ 350:2500

# Extracting a specific wavelengths range
s <- cut(australia, wl = 450:550)
plot(s)

s <- cut(australia, wl = c(450:550, 1850:2050))
plot(s)

# Removing a specific wavelengths range
s <- cut(australia, wl = -1*450:550)
plot(s)

s <- cut(australia, wl = -1*c(450:550, 1850:2050))
plot(s)

}
\author{
Pierre Roudier \url{pierre.roudier@gmail.com}
}
