% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BWR.R
\name{BWR}
\alias{BWR}
\title{BW ratio calculation}
\usage{
BWR(X, groupLabel)
}
\arguments{
\item{X}{The spectral dataset in the matrix format in which each row contains a single sample.}

\item{groupLabel}{Group label of samples in the dataset.}
}
\value{
Return BW ratio
}
\description{
Compute the BW ratios from data groups
}
\examples{
res=makeSimulatedData();
X=res$data;
groupLabel=res$label;
peakList <- detectSpecPeaks(X,
                            nDivRange = c(128),
                            scales = seq(1, 16, 2),
                            baselineThresh = 50000,
                            SNR.Th = -1,
                            verbose=FALSE
);
resFindRef<- findRef(peakList);
refInd <- resFindRef$refInd;
maxShift = 50;
Y <- dohCluster(X,
                peakList = peakList,
                refInd = refInd,
                maxShift  = maxShift,
                acceptLostPeak = TRUE, verbose=FALSE);
# find the BW-statistic
BW = BWR(Y, groupLabel);

}
\seealso{
\code{\link{createNullSampling}}
}
\author{
Trung Nghia Vu
}
