\name{aple.mc}
\alias{aple.mc}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{Approximate profile-likelihood estimator (APLE) permutation test}
\description{
  A permutation bootstrap test for the approximate profile-likelihood estimator (APLE).
}
\usage{
aple.mc(x, listw, nsim, override_similarity_check=FALSE, useTrace=TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x}{a zero-mean detrended continuous variable}
  \item{listw}{a \code{listw} object from for example \code{nb2listw}}
  \item{nsim}{number of simulations}
  \item{override\_similarity\_check}{default FALSE, if TRUE - typically for row-standardised weights with asymmetric underlying general weights - similarity is not checked}
  \item{useTrace}{default TRUE, use trace of sparse matrix \code{W \%*\% W} (Li et al. (2010)), if FALSE, use crossproduct of eigenvalues of \code{W} as in Li et al. (2007)}
}

\value{
  A \code{boot} object as returned by the \code{boot} function.
}
\references{Li, H, Calder, C. A. and Cressie N. A. C. (2007) Beyond Moran's I: testing for spatial dependence based on the spatial autoregressive model. Geographical Analysis 39, 357-375; Li, H, Calder, C. A. and Cressie N. A. C. (2012) One-step estimation of spatial dependence parameters: Properties and extensions of the APLE statistic, Journal of Multivariate Analysis 105, 68-84.}
\author{Roger Bivand \email{Roger.Bivand@nhh.no}}

\seealso{\code{\link{aple}}, \code{\link[boot]{boot}}}
\examples{
\dontrun{
example(aple)
boot_out <- aple.mc(as.vector(scale(wheat$yield_detrend, scale=FALSE)),
 nb2listw(nbr12, style="W"), nsim=500)
plot(boot_out)
boot_out
library(parallel)
cl <- makeCluster(detectCores())
set.ClusterOption(cl)
set.rlecuyerSeedOption(1:6)
boot_out <- aple.mc(as.vector(scale(wheat$yield_detrend, scale=FALSE)),
 nb2listw(nbr12, style="W"), nsim=500)
boot_out
set.ClusterOption(NULL)
stopCluster(cl)
}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{spatial}

