% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_table.r
\name{map_table}
\alias{map_table}
\title{A decomposition of 'vector' map data structures to tables.}
\usage{
map_table(x, ...)
}
\arguments{
\item{x}{object to tidy}

\item{...}{arguments passed to methods}
}
\value{
list of tibbles
}
\description{
Creates a set of related tables to store the appropriate
entities in spatial map data.
}
\details{
The basic entities behind spatial data, and hence the "map tables" are:
\describe{
 \item{vertices}{the positions in geometric space, e.g. x, y, z, time, long, lat, salinity etc.}
 \item{branches}{a single connected chain of vertices, or "parts"}
 \item{objects}{a collection of branches aligned to a row of metadata}
 }

 This is the basic "topology" of traditional GIS vector data, for points,
 lines, polygons and their multi-counterparts. By default map_tables will
 produce these tables and also de-duplicated the input vertices, adding a
 fourth table to link vertices to branches.

 Other topology types such as triangle or quad meshes can extend this
 four-entity model, or exist without the branches at all. See "mesh_table" ??

 These are currently classed as object_table, branch_table, branch_link_vertex_table, and vertex_table. But there are no methods.
}
