% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postprocessing.R
\name{baselinehazard}
\alias{baselinehazard}
\title{baselinehazard function}
\usage{
baselinehazard(x, t = NULL, n = 100, probs = c(0.025, 0.5, 0.975),
  cumulative = FALSE, plot = TRUE, bw = FALSE, ...)
}
\arguments{
\item{x}{an object inheriting class mcmcspatsurv}

\item{t}{optional vector of times at which to compute the quantiles, Defult is NULL, in which case a uniformly spaced vector of length n from 0 to the maximum time is used}

\item{n}{the number of points at which to compute the quantiles if t is NULL}

\item{probs}{vector of probabilities}

\item{cumulative}{logical, whether to return the baseline hazard (default i.e. FALSE) or cumulative baseline hazard}

\item{plot}{whether to plot the result}

\item{bw}{Logical. Plot in black/white/greyscale? Default is to produce a colour plot. Useful for producing plots for journals that do not accept colour plots.}

\item{...}{additional arguments to be passed to plot}
}
\value{
the vector of times and quantiles of the baseline or cumulative baseline hazard at those times
}
\description{
A function to compute quantiles of the posterior baseline hazard or cumulative baseline hazard.
}
\seealso{
\link{print.mcmcspatsurv}, \link{quantile.mcmcspatsurv}, \link{summary.mcmcspatsurv}, \link{vcov.mcmcspatsurv}, 
\link{frailtylag1}, \link{spatialpars}, \link{hazardpars}, \link{fixedpars}, \link{randompars},
\link{predict.mcmcspatsurv}, \link{priorposterior}, \link{posteriorcov}, \link{MCE},
\link{hazardexceedance}
}

