% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ripleys_k.R
\name{bi_ripleys_k}
\alias{bi_ripleys_k}
\title{Calculate Bivariate Ripley's K function for IF data}
\usage{
bi_ripleys_k(
  mif,
  id,
  mnames,
  r_range = seq(0, 100, 50),
  num_permutations = 50,
  edge_correction = "translation",
  kestimation = TRUE,
  keep_perm_dis = FALSE,
  mlabels = NULL
)
}
\arguments{
\item{mif}{An MIF object}

\item{id}{Character string of variable name for subject ID in TMA data.}

\item{mnames}{A list of character strings containing two marker names}

\item{r_range}{Numeric vector of potential r values to estimate K at.}

\item{num_permutations}{Numeric value indicating the number of permutations used.
Default is 50.}

\item{edge_correction}{Character value indicating the type of edge correction
to use. Options include "theoretical", "translation", "isotropic" or "border".
Various edges corrections are most appropriate in different settings. Default
is "none".}

\item{kestimation}{Logical value determining the type estimation performed.
TRUE estimates Ripley's reduced second moment function while FALSE
estimates Besags's transformation of Ripley's K.}

\item{keep_perm_dis}{Logical value determining whether or not to keep the full
distribution of permuted K values}

\item{mlabels}{A list of character strings containing two marker labels}
}
\value{
Returns a list of data frames
\item{sample}{Subject ID in TMA data}
\item{marker}{Ripley's K estimate using translation edge correction}
\item{theoretical_estimate}{theoretical value of k}
\item{observed_estimate}{observed estimate of k}
}
\description{
This function calculates Ripley's K function of IF data for
two markers.
}
