% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.spatgeom}
\alias{print.spatgeom}
\title{print a \code{spatgeom} object}
\usage{
\method{print}{spatgeom}(x, return_table = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{spatgeom}}

\item{return_table}{if \code{TRUE}, returns a data frame with the
estimated values. Otherwise, print the data frame in console. Defaults to
\code{FALSE}}

\item{...}{further arguments passed to the \code{plot} function}
}
\value{
Print the estimate given by \code{\link{alphastats}}.
}
\description{
Print method for objects of class \code{spatgeom}.
}
\examples{
n <- 30
a <- -1
b <- 1
theta <- runif(n, 0, 2 * pi)
r <- (sqrt(runif(n))) * (0.5) + 0.5
X1 <- r * cos(theta)
X2 <- runif(n, a, b)
Y <- data.frame(Y = r * sin(theta))
X <- data.frame(X1, X2)

estimation <- alphastats(y = Y, x = X)

print(estimation)

}
