% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.groups.r
\name{get.groups}
\alias{get.groups}
\title{Generate Time Series with Negative Binomial Distribution and Multivariate Gamma Frailty with Autoregressive Correlation Structure of Order One with Trend}
\source{
\code{rnbinom.gf} computes observations from a Gamma frailty model by \emph{Fiocco et. al. 2009} using code contributed by Thomas Asendorf.
}
\usage{
get.groups(n, size, lambda, rho, tp, trend)
}
\arguments{
\item{n}{number of observations.}

\item{size}{dispersion parameter (the shape parameter of the gamma mixing distribution). Must be strictly positive, need not be integer.}

\item{lambda}{vector of means of trend parameters.}

\item{rho}{correlation coefficient of the underlying autoregressive Gamma frailty. Must be between 0 and 1.}

\item{tp}{number of observed time points.}

\item{trend}{a string giving the trend which is to be simulated.}
}
\value{
\code{get.groups} returns a matrix of dimension \code{n} x \code{tp} with marginal negative binomial
distribution with means corresponding to trend parameters \code{lambda}, common dispersion parameter \code{size} and a correlation induce by \code{rho},
the correlation coefficient of the autoregressive multivariate Gamma frailty.
}
\description{
\code{rnbinom.gf} generates one or more independent time series following the Gamma frailty model. The generated data has negative binomial marginal distribution and the underlying multivariate Gamma frailty an autoregressive covariance structure.
}
\details{
The function relies on \code{\link{rnbinom.gf}} for creating data with underlying constant or exponential trends.
}
\examples{
random<-get.groups(n=c(1000,1000), size=c(0.5, 0.5), lambda=c(1, 2), rho=c(0.6, 0.6), tp=7,
  trend="constant")
head(random)

}
\references{
Fiocco M, Putter H, Van Houwelingen JC, (2009), A new serially correlated gamma-frailty process for longitudinal count data \emph{Biostatistics} Vol. 10, No. 2, pp. 245-257.
}
\seealso{
\code{\link{rnbinom.gf}} for information on the Gamma frailty model.
}
