% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_cov_cor.R
\name{gen_cov_cor}
\alias{gen_cov_cor}
\title{Generation of covariance- or correlation-matrices}
\source{
\code{gen_cov_cor} uses code contributed by Roland Gerard Gera

 @seealso \code{\link{r.gee.1subgroup}} for information on the generated longitudinal data and \code{\link{n.gee.1subgroup}} for the calculation of
initial sample sizes for longitudinal GEE-models and \code{\link{bssr.gee.1subgroup}} for blinded
sample size reestimation within a trial See \code{\link{estimcov}} for more information on the used minimization algorithms.
}
\usage{
gen_cov_cor(var = 1, rho, theta, Time, cov = TRUE)
}
\arguments{
\item{var}{variance at each timepoint}

\item{rho}{correlation between two adjacent timepoints 1 timeunit appart}

\item{theta}{variable specifying the type of the correlation structure: see 'Details'}

\item{Time}{list with time measures which are used to generate the covariance- or correlation-structure: see 'Details'}

\item{cov}{TRUE/FALSE statement which determines if a covariance- or a correlation-matrix is generated.}
}
\value{
\code{gen_cov_cor} returns the covariance- or correlation-matrix, depending if \code{cov} was \code{TRUE} or \code{FALSE}.
}
\description{
Generate covariance- or correlation-matrices given the parameters \code{var}, \code{rho}, \code{theta} for the covariance structure, \code{Time} for the observed timepoints and \code{cov=TRUE} if a covariance or \code{cov=FALSE} if a correlation-matrix is to be generated.
}
\details{
The function \code{gen_cov_cor} is used to generate either a covariance- or a correlation-matrix. Given vector \code{Time} and parameters \code{var}, \code{rho} and \code{theta} the covariance or correlation between two timepoints is described: The way the correlation between two timepoints is described by

\eqn{cov(Time[i],Time[j])=var*(rho^(abs(Time[i]-Time[j])^theta))}

for covariance and 

\eqn{corr(Time[i],Time[j])=rho^(abs(Time[i]-Time[j])^theta)}

for correlation. 
[The above sentence would be better is we write the following sentence:]
[[The following two equations are used to calculate
the covariance and the correlation between two timepoints, respectively:
cov(Time[i],Time[j])=var*(rho^(abs(Time[i]-Time[j])^theta))
corr(Time[i],Time[j])=rho^(abs(Time[i]-Time[j])^theta) ]]

Which of the two formulas is used depends on \code{cov}
}
\examples{
#Generate a covariance-matrix with measurements at Baseline and at timeunit 1,1.5,2 
#and 5 (hours,day,months,years, etc.) 

covar<-gen_cov_cor(var=3,rho=0.25,theta=1,Time=c(0,1,1.5,2,5),cov=TRUE)
covar

#Generate a correlation-matrix

corr<-gen_cov_cor(rho=0.25,theta=1,Time=c(0,1,1.5,2,5),cov=FALSE)
corr
}

