% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/robustness_analysis.R
\name{produce_summary_for_all_values_of_parameter}
\alias{produce_summary_for_all_values_of_parameter}
\title{For one parameter, evaluate the results of all values that parameter can take}
\usage{
produce_summary_for_all_values_of_parameter(FILEPATH, param,
  param_val_list, BASELINE, baseline_evaluated, PARAMETERS, EXP_PARAMS,
  NUMRUNSPERSAMPLE, MEASURES, RESULTFILENAME, ALTERNATIVEFILENAME,
  OUTPUTCOLSTART, OUTPUTCOLEND)
}
\arguments{
\item{FILEPATH}{Directory where either the simulation runs or single CSV file result can be found}

\item{param}{Current index of parameter being evaluated}

\item{param_val_list}{List of values this parameter can take}

\item{BASELINE}{Array containing the values assigned to each of these parameters in the calibrated baseline}

\item{baseline_evaluated}{Whether results for the baseline have been calculated}

\item{PARAMETERS}{Array containing the names of the parameters for which local analyses are being conducted}

\item{EXP_PARAMS}{Set of the value of all parameters being examined}

\item{NUMRUNSPERSAMPLE}{The number of runs performed for each parameter subset. This figure is generated through Aleatory Analysis}

\item{MEASURES}{Array containing the names of the output measures which are used to analyse the simulation}

\item{RESULTFILENAME}{Name of the simulation results file. In the current version, XML and CSV files can be processed. If performing this analysis over multiple timepoints, it is assumed that the timepoint follows the file name, e.g. trackedCells_Close_12.csv.}

\item{ALTERNATIVEFILENAME}{In some cases, it may be relevant to read from a further results file if he initial file contains no results. This filename is set here.}

\item{OUTPUTCOLSTART}{Column number in the simulation results file where output begins - saves (a) reading in unnecessary data, and (b) errors where the first column is a label, and therefore could contain duplicates.}

\item{OUTPUTCOLEND}{Column number in the simulation results file where the last output measure is. Only required if running the first method.}
}
\value{
The results for this parameter, and whether the baseline has been evaluated
}
\description{
For one parameter, evaluate the results of all values that parameter can take
}
