% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_plotting.R
\name{lhc_polarplot}
\alias{lhc_polarplot}
\title{Creates a polar plot for each response, showing PRCC for each parameter}
\usage{
lhc_polarplot(FILEPATH, PARAMETERS, MEASURES, CORCOEFFSOUTPUTFILE,
  TIMEPOINTS = NULL, TIMEPOINTSCALE = NULL)
}
\arguments{
\item{FILEPATH}{Directory where the simulation runs of single CSV file can
be found}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{MEASURES}{Array containing the names of the output measures which are
used to analyse the simulation}

\item{CORCOEFFSOUTPUTFILE}{File produced by spartan containing the Partial
Rank Correlation Coefficients for each parameter/measure pairing}

\item{TIMEPOINTS}{Implemented so this method can be used when analysing
multiple simulation timepoints. If only analysing one timepoint, this should
be set to NULL. If not, this should be an array of timepoints,
e.g. c(12,36,48,60)}

\item{TIMEPOINTSCALE}{Implemented so this method can be used when analysing
multiple simulation timepoints. Sets the scale of the timepoints being
analysed, e.g. "Hours"}
}
\description{
Added in Spartan 3.0. Provides a means of plotting the partial rank
correlation coefficients as a polar plot, to ease comparison of these values.
}
