% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_sampling.R
\name{lhc_generate_lhc_sample}
\alias{lhc_generate_lhc_sample}
\title{Generates sets of simulation parameters using latin-hypercube sampling}
\usage{
lhc_generate_lhc_sample(FILEPATH, PARAMETERS, NUMSAMPLES, PMIN, PMAX,
  ALGORITHM, PINC = NULL, write_csv = TRUE)
}
\arguments{
\item{FILEPATH}{Directory where the parameter samples should be output to}

\item{PARAMETERS}{Array containing the names of the parameters of which
parameter samples will be generated}

\item{NUMSAMPLES}{The number of parameter subsets to generate}

\item{PMIN}{Array containing the minimum value that should be used for
each parameter. Sets a lower bound on sampling space}

\item{PMAX}{Array containing the maximum value that should be used for
each parameter. Sets an upper bound on sampling space}

\item{ALGORITHM}{Choice of algorithm to use to generate the hypercube.
Can be set to either 'normal' or 'optimum'. Beware optimum can take a
long time to generate an optimised parameter set (more than 24 hours
in some circumstances)}

\item{PINC}{Array containing the increment value that should be applied
for each parameter. For example, a parameter could have a minimum value
of 10, and maximum value of 100, and be incremented by 10. Added after
user request on Github}

\item{write_csv}{Whether the sample should be output to a CSV file or not.
Introduced with spartan database link. Defaults to TRUE}
}
\value{
LHC generated parameter sets
}
\description{
Though robustness analysis does elucidate the effects of perturbations of
one parameter, it cannot show any non-linear effects which occur when two
or more are adjusted simultaneously. A Global Sensitivity Analysis
technique is needed to identify such effects, and to give an indication
of the parameters which have the greatest influence on the simulation
output. This technique uses the method described by Read et al in their
paper reference in the tutorial, which uses a latin-hypercube design to
sample the parameter space. Ranges are set for each parameter, and all
parameter values perturbed concurrently. This method creates the parameter
value sets with which simulations should be run. This is output as a CSV
file. For each set of parameters, the simulation should be run for the
number of times identified in Aleatory Analysis. Once this has been
completed, the set of remaining methods within spartan can be used to
analyse the results. Note: To run this, you will require the lhs library.
Version 3.1 adds returning the sample as a object, should this be easier
to process than reading back in a file
}
