% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lhc_analysis.R
\name{summarise_lhc_sweep_responses}
\alias{summarise_lhc_sweep_responses}
\title{Processes an LHC sample, returning summary stats for all parameter sets}
\usage{
summarise_lhc_sweep_responses(filepath, numrunspersample, parameters, measures,
  resultfilename, altfilename, num_samples, lhctable, outputcolstart,
  outputcolend)
}
\arguments{
\item{filepath}{Directory where the simulation runs of single CSV file can
be found}

\item{numrunspersample}{The number of runs performed for each parameter
subset. This figure is generated through Aleatory Analysis. Only required
if analysing results provided within Folder structure setup.}

\item{parameters}{Simulation parameters being analysed / perturbed}

\item{measures}{Array containing the names of the output measures which are
used to analyse the simulation}

\item{resultfilename}{Name of the simulation results file. In the current
version, XML and CSV files can be processed. If performing this analysis
over multiple timepoints, it is assumed that the timepoint follows the
file name, e.g. trackedCells_Close_12.csv.}

\item{altfilename}{In some cases, it may be relevant to read from
a further results file if the initial file contains no results. This
filename is set here. In the current version, XML and CSV files can be
processed.}

\item{num_samples}{The number of parameter subsets that were generated in the
LHC design. Only required if analysing results provided within Folder
structure setup.}

\item{lhctable}{Parameter sets generated by LHC sampling}

\item{outputcolstart}{Column number in the simulation results file where
output begins - saves (a) reading in unnecessary data, and (b) errors where
the first column is a label, and therefore could contain duplicates.}

\item{outputcolend}{Column number in the simulation results file where the
last output measure is.}
}
\value{
Summary stats for all parameter sets
}
\description{
Processes an LHC sample, returning summary stats for all parameter sets
}
