lhc_process_sample_run_subsets <-
function(FILEPATH,SPARTAN_PARAMETER_FILE,PARAMETERS,NUMSAMPLES,NUMRUNSPERSAMPLE,MEASURES,RESULTFILENAME,ALTERNATIVEFILENAME,OUTPUTCOLSTART,OUTPUTCOLEND,LHC_ALL_SIM_RESULTS_FILE,TIMEPOINTS=NULL,TIMEPOINTSCALE=NULL)
{
	# CREATE THE MEDIAN DISTRIBUTION OVER THE SET OF RUNS FOR EACH PARAMETER SET CREATED IN LHC SAMPLING
	# SPARTAN VERSION 2: THESE MEDIANS ARE NOW STORED IN ONE SINGLE FILE, NOT PER PARAMETER VALUE AS IN SPARTAN 1.0-1.3. 
	# LATER PROCESSING NOW DEALS WITH THESE FILES ONLY.
	# NOTE FROM SPARTAN 2, THIS FILE CAN ONLY BE A CSV FILE - XML FILES OF THIS SIZE TAKE A LARGE AMOUNT OF TIME TO PROCESS

	if(is.null(TIMEPOINTS))
	{
		if(file.exists(FILEPATH))
		{
			print("Generating Simulation Median Responses (process_sample_run_subsets)")

			# READ IN THE SPARTAN PARAMETER FILE
			LHCTABLE<-read.csv(paste(FILEPATH,"/",SPARTAN_PARAMETER_FILE,sep=""),header=TRUE)

			# NOW ALL THE MEDIANS ARE HELD TOGETHER, ACCOMPANIED BY THEIR SIMULATION PARAMETERS BEING ANALYSED
			ALL_SIM_MEDIAN_RESULTS<-NULL
		
			for(k in 1:NUMSAMPLES)
			{
				print(paste("Generating Median Simulation Responses for Parameter Set ",k,sep=""))

				# GET THE PARAMETER VALUES FOR THIS SET
				PARAMROW <- as.numeric(LHCTABLE[k,])

				SIMRESULTFILE<-paste(FILEPATH,"/",k,"/",RESULTFILENAME,sep="")
			
				MEDIAN_RESULTS<-getMediansSubset(paste(FILEPATH,"/",k,"/",sep=""),NUMRUNSPERSAMPLE,MEASURES,
					RESULTFILENAME,ALTERNATIVEFILENAME,OUTPUTCOLSTART,OUTPUTCOLEND)

				RUN_PARAMS<-NULL						
				for(p in 1:length(PARAMROW))
				{
					RUN_PARAMS<-cbind(RUN_PARAMS,array(as.numeric(PARAMROW[p]),dim=c(nrow(MEDIAN_RESULTS))))
				}
				# NOW BIND THESE PARAMS TO THE RESULTS
				PARAMRESULT<-cbind(RUN_PARAMS,MEDIAN_RESULTS)

				# NOW ADD THIS TO THE LIST OF ALL MEDIANS BEING PROCESSED IN THIS ANALYSIS
				ALL_SIM_MEDIAN_RESULTS<-rbind(ALL_SIM_MEDIAN_RESULTS,PARAMRESULT)

			
			}

			# NOW OUTPUT ALL THE MEDIAN RESULTS TO THE SPECIFIED FILEPATH
			colnames(ALL_SIM_MEDIAN_RESULTS)<-cbind(t(PARAMETERS),t(MEASURES))

			# OUTPUT IF THE RESULTS ARE NOT BLANK
			if(!is.null(ALL_SIM_MEDIAN_RESULTS))
			{
				RESULTSFILE = paste(FILEPATH,"/",LHC_ALL_SIM_RESULTS_FILE,sep="")
				print(paste("Writing Median Results to CSV File: ",RESULTSFILE,sep=""))
				write.csv(ALL_SIM_MEDIAN_RESULTS,RESULTSFILE,quote = FALSE,row.names=FALSE)
			}
		
		}
		else
		{
			print("The directory specified in FILEPATH does not exist. No analysis performed")
		}
	}
	else
	{
		# PROCESS EACH TIMEPOINT, BY AMENDING THE FILENAMES AND RECALLING THIS FUNCTION
		for(n in 1:length(TIMEPOINTS))
		{

			TIMEPOINTPROCESSING<-TIMEPOINTS[n]
			print(paste("PROCESSING TIMEPOINT: ",TIMEPOINTPROCESSING,sep=""))

			RESULTFILEFORMAT<-substr(RESULTFILENAME,(nchar(RESULTFILENAME)+1)-3,nchar(RESULTFILENAME))
			SIMRESULTFILENAME<-paste(substr(RESULTFILENAME,0,nchar(RESULTFILENAME)-4),"_",TIMEPOINTPROCESSING,".",RESULTFILEFORMAT,sep="")

			if(!is.null(ALTERNATIVEFILENAME))
			{
				ALTERNATIVEFILENAMEFULL<-paste(substr(ALTERNATIVEFILENAME,0,nchar(ALTERNATIVEFILENAME)-4),"_",TIMEPOINTPROCESSING,".",RESULTFILEFORMAT,sep="")
			}
			else
			{
				ALTERNATIVEFILENAMEFULL<-ALTERNATIVEFILENAME
			}

			MEDIANSFILEFORMAT<-substr(LHC_ALL_SIM_RESULTS_FILE,(nchar(LHC_ALL_SIM_RESULTS_FILE)+1)-3,nchar(LHC_ALL_SIM_RESULTS_FILE))

			LHC_ALL_SIM_RESULTS_FILEFULL<-paste(substr(LHC_ALL_SIM_RESULTS_FILE,0,nchar(LHC_ALL_SIM_RESULTS_FILE)-4),"_",TIMEPOINTPROCESSING,".",MEDIANSFILEFORMAT,sep="")

			# NOW CALL THIS FUNCTION AGAIN TO DO THE TIMEPOINTS - WE SET THE TIMEPOINTS AND TIMEPOINTSCALE TO NULL NOW SO WE DONT END UP BACK IN THIS ELSE

			lhc_process_sample_run_subsets (FILEPATH,SPARTAN_PARAMETER_FILE,PARAMETERS,NUMSAMPLES,NUMRUNSPERSAMPLE,MEASURES,SIMRESULTFILENAME,ALTERNATIVEFILENAME,OUTPUTCOLSTART,OUTPUTCOLEND,LHC_ALL_SIM_RESULTS_FILEFULL,NULL,NULL)
		}
	}
}

