oat_process_netlogo_result <-
function(FILEPATH,NETLOGO_BEHAVIOURSPACEFILE,PARAMETERS,BASELINE,PMIN,PMAX,PINC,MEASURES,RESULTFILEFORMAT,RESULTFILENAME,TIMESTEP)
{
	# NOTE THAT ALTHOUGH NETLOGO FILE CONTAINS EACH PARAMETER FOR THE TURTLE, THE INPUT HERE ONLY NEEDS TO BE THE
	# PARAMETERS THAT HAVE BEEN PERTURBED

	# Check the parameter and measures strings
	PARAMETERS<-table_header_check(PARAMETERS)
	MEASURES<-table_header_check(MEASURES)

	## FIRSTLY READ IN THE NETLOGO RESULT FILE
	NL_RESULT<-read.csv(paste(FILEPATH,"/",NETLOGO_BEHAVIOURSPACEFILE,sep=""),sep=",",skip=6)

	# ORDER IT BY RUN FOR EFFICIENCY LATER
	NL_RESULT_ORDERED<-NL_RESULT[order(NL_RESULT[,1]),]

	# REMOVE ALL THE OTHER TIMESTEPS AS NOT REQUIRED
	# THE TIMESTEP IS IN THE COLUMN HEADED X.step.
	# SET THIS TO NULL TO PLEASE CRAN SUBMISSION NOTE, THEN SUBSET
	X.step.<-NULL
	TIMESTEP_RESULTS<-subset(NL_RESULT_ORDERED,X.step.==TIMESTEP)

	# NOW TO DO A ONE-A-TIME ANALYSIS FOR EACH PARAMETER
	for(PARAM in 1:length(PARAMETERS))
	{
		# THE DIFFERENCE WITH REFERING TO THE NETLOGO RESULT FILE RATHER THAN TRADITIONAL SPARTAN IS ALL THE RESULTS OF 
		# THE OAT ANALYSIS IS IN ONE PLACE. THUS WE NEED TO REFER TO THE CORRECT BASELINE RESULT FOR PARAMETERS THAT ARE
		# NOT BEING CHANGED
		# SO WE USE THE VARIABLE EXP_PARAMS WHEN WE START A NEW VARIABLE - WE SET THE PARAMS TO THE BASELINE AND THEN ONLY
		# ALTER THE ONE BEING CHANGED
		EXP_PARAMS<-BASELINE

		# CREATE A FOLDER IN THE RESULTS STORE FOR THIS PARAMETER
		dir.create(file.path(FILEPATH,PARAMETERS[PARAM]), showWarnings = FALSE)

		# NOW TO DO ALL THE VALUES OF THIS PARAMETER
		for(PARAMVAL in seq(PMIN[PARAM],PMAX[PARAM],by=PINC[PARAM]))
		{
			# DUE TO POTENTIAL OF ROUNDING ERRORS IN SEQ, THE VALUE MAY NOT MATCH THE PARAMETER
			# SO ROUND THE VALUE TO THE NUMBER OF DECIMAL PLACES IN THE INCREMENT
			dp<-num.decimals(PINC[PARAM])
			PARAMVAL<-round(PARAMVAL,digits=dp)

			# CREATE A FOLDER IN THE RESULTS STORE FOR THIS PROCESSED RESULT
			dir.create(file.path(paste(FILEPATH,"/",PARAMETERS[PARAM],"/",sep=""), PARAMVAL), showWarnings = FALSE)

			print(paste("Processing NetLogo Results for Parameter: ",PARAMETERS[PARAM],", Value: ",PARAMVAL,sep=""))

			# SET THE VALUE OF THIS PARAMETER TO BE THAT WE ARE PROCESSING
			EXP_PARAMS[PARAM] <- PARAMVAL

			# TAKE A COPY OF THE RESULTS FOR THIS TIMESTEP. WE'RE GOING TO FILTER THIS FOR THIS PARAMETER & VALUE
			FILTEREDRESULTS<-TIMESTEP_RESULTS

			# NOW TO EXTRACT THIS DATA FROM THE BEHAVIOUR SPACE FILE, MAKING SURE PARAMETERS NOT OF INTEREST ARE AT BASELINE VALUE
			for(PARAMOFINT in 1:length(PARAMETERS))
			{
				FILTEREDRESULTS<-subset(FILTEREDRESULTS,FILTEREDRESULTS[[PARAMETERS[PARAMOFINT]]]==EXP_PARAMS[PARAMOFINT])
			}

			# NOW WE HAVE THE SET OF RESULTS FOR THIS OAT RUN
			# NETLOGO DOES GIVE THE OPTION OF RUNNING REPLICATES OF THE SAME EXPERIMENT
			# SO THERE MAY BE A FEW ROWS HERE. IF SO, LETS TAKE THE MEDIAN OF THE MEASURES, AS WE WOULD WITH TRADITIONAL SPARTAN
			MEDIANSFORALLMEASURES<-NULL

			for(RESPONSE in 1:length(MEASURES))
			{
				MEDIANSFORALLMEASURES<-cbind(MEDIANSFORALLMEASURES,median(FILTEREDRESULTS[MEASURES[RESPONSE]][,1]))
			}

			colnames(MEDIANSFORALLMEASURES)<-MEASURES

			PARAM_RESULTFILEPATH = paste(FILEPATH,"/",PARAMETERS[PARAM],"/",PARAMVAL,"/",RESULTFILENAME,sep="")

			if(RESULTFILEFORMAT=="csv")
			{
				write.csv(MEDIANSFORALLMEASURES,paste(PARAM_RESULTFILEPATH,".csv",sep=""),quote = FALSE,row.names=FALSE)
			}
			else if(RESULTFILEFORMAT=="xml")
			{
				RESULTSDF<-data.frame(MEDIANSFORALLMEASURES)
			
				#xml <- xmlTree()
				xml<-xmlOutputDOM()
				xml$addTag("simResults", close=FALSE)
				for (i in 1:nrow(RESULTSDF)) 
				{
					xml$addTag("runMedians", close=FALSE)
					for (j in names(RESULTSDF)) 
					{
						xml$addTag(j, RESULTSDF[i, j])
					}
					xml$closeTag()
				}
				xml$closeTag()	
			
				saveXML(xml,file=paste(PARAM_RESULTFILEPATH,".xml",sep=""),indent=FALSE)
			}
		}
	}
}
