% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_power.R
\name{spatial_power}
\alias{spatial_power}
\title{Power of SRR function for randomly generated data.}
\usage{
spatial_power(
  win = spatstat::unit.square(),
  sim_total = 2,
  x_case,
  y_case,
  samp_case = c("uniform", "MVN", "CSR", "IPP"),
  samp_control = c("uniform", "systematic", "MVN", "CSR", "IPP", "clustered"),
  x_control = NULL,
  y_control = NULL,
  n_case = NULL,
  n_control = NULL,
  npc_control = NULL,
  r_case = NULL,
  r_control = NULL,
  s_case = NULL,
  s_control = NULL,
  l_case = NULL,
  l_control = NULL,
  e_control = NULL,
  lower_tail = 0.025,
  upper_tail = 0.975,
  cascon = FALSE,
  verbose = TRUE,
  parallel = FALSE,
  n_core = 2,
  ...
)
}
\arguments{
\item{win}{Window in which to simulate the random data. An object of class "owin" or something acceptable to \code{\link[spatstat]{as.owin}}.}

\item{sim_total}{Integer, specifying the number of simulation iterations to perform.}

\item{x_case}{Numeric value, or numeric vector, of x-coordinate(s) of case cluster(s).}

\item{y_case}{Numeric value, or numeric vector, of y-coordinate(s) of case cluster(s).}

\item{samp_case}{Character string specifying whether to randomize the case locations uniformly (\code{samp_control="uniform"}), multivariate normal (\code{samp_control="MVN"}), with complete spatial randomness (\code{samp_control="CSR"}), or using the inhomogeneous Poisson process (\code{samp_control="IPP"}) around each case centroid.}

\item{samp_control}{Character string specifying whether to randomize the control locations uniformly (\code{samp_control="uniform"}), systematically (\code{samp_control="systematic"}), multivariate normal (\code{samp_control="MVN"}), with complete spatial randomness (\code{samp_control="CSR"}), using the inhomogeneous Poisson process (\code{samp_control="IPP"}), or a realisation of the Neyman-Scott cluster process (\code{samp_control="clustered"}).}

\item{x_control}{Numeric value, or numeric vector, of x-coordinate(s) of case cluster(s). Ignored if \code{samp_control!="MVN"}.}

\item{y_control}{Numeric value, or numeric vector, of y-coordinate(s) of case cluster(s). Ignored if \code{samp_control!="MVN"}.}

\item{n_case}{Numeric value, or numeric vector, of the sample size for case locations in each cluster.}

\item{n_control}{Numeric value, or numeric vector, of the sample size for control locations in each cluster.}

\item{npc_control}{Optional. Numeric value of the number of clusters of control locations. Ignored if \code{samp_control!="clustered"}.}

\item{r_case}{Optional. Numeric value, or numeric vector, of radius (radii) of case cluster(s) in the units of \code{win}. Ignored if \code{samp_case="MVN"}.}

\item{r_control}{Optional. Numeric value, or numeric vector, of radius (radii) of control cluster(s) in the units of \code{win}. Ignored if \code{samp_control!="clustered"}.}

\item{s_case}{Optional. Numeric value, or numeric vector, for the standard deviation(s) of the multivariate normal distribution for case locations in the units of \code{win}. Ignored if \code{samp_control!="MVN"}.}

\item{s_control}{Optional. Numeric value, or numeric vector, for the standard deviation(s) of the multivariate normal distribution for control locations in the units of \code{win}. Ignored if \code{samp_control!="MVN"}.}

\item{l_case}{Optional. A single positive number, a vector of positive numbers, a function(x,y, ...), or a pixel image. Intensity of the Poisson process for case clusters. Ignored if \code{samp_control!="IPP"}.}

\item{l_control}{Optional. A single positive number, a vector of positive numbers, a function(x,y, ...), or a pixel image. Intensity of the Poisson process for control clusters. Ignored if \code{samp_control="uniform"}, \code{samp_control="systematic"}, \code{samp_control="MVN"}, or \code{samp_control="CSR"}.}

\item{e_control}{Optional. A single non-negative number for the size of the expansion of the simulation window for generating parent points. Ignored if \code{samp_control!="clustered"}.}

\item{lower_tail}{Optional. Numeric value of lower p-value threshold (default=0.025).}

\item{upper_tail}{Optional. Numeric value of upper p-value threshold (default=0.975). Ignored if cascon=FALSE.}

\item{cascon}{Logical. If TRUE, computes the statistical power to detect case clusters and control clusters. If FALSE (the default), computes the statistical power to detect case clusters only.}

\item{verbose}{Logical. If TRUE (the default), will print function progress during execution. If FALSE, will not print.}

\item{parallel}{Logical. If TRUE, will execute the function in parallel. If FALSE (the default), will not execute the function in parallel.}

\item{n_core}{Optional. Integer specifying the number of CPU cores on current host to use for parallelization (the default is 2 cores).}

\item{...}{Arguments passed to \code{\link[spatstat]{runifdisc}}, \code{\link[spatstat]{disc}}, \code{\link[spatstat]{rpoispp}}, \code{\link[spatstat]{rsyst}}, or \code{\link[spatstat]{rNeymanScott}} depending on \code{samp_control} or \code{samp_control}. Arguments also passed to \code{\link[sparr]{risk}} to select bandwidth, edge correction, and resolution.}
}
\value{
An object of class "list". This is a named list with the following components:

#' \describe{
\item{\code{sim}}{An object of class 'rrs' for the first iteration of simulated data.}
\item{\code{out}}{An object of class 'rrs' for the observed spatial relative risk function without randomization.}
\item{\code{rr_mean}}{Vector of length \code{[resolution x resolution]} of the mean relative risk values at each gridded knot.}
\item{\code{pval_mean}}{Vector of length \code{[resolution x resolution]} of the mean asymptotic p-value at each gridded knot.}
\item{\code{rr_sd}}{Vector of length \code{[resolution x resolution]} of the standard deviation of relative risk values at each gridded knot.}
\item{\code{rr_mean}}{Vector of length \code{[resolution x resolution]} of the proportion of asymptotic p-values that were significant at each gridded knot.}
\item{\code{rx}}{Vector of length \code{[resolution x resolution]} of the x-coordinates of each gridded knot.}
\item{\code{ry}}{Vector of length \code{[resolution x resolution]} of the y-coordinates of each gridded knot.}
\item{\code{rx}}{Vector of length \code{sim_total} of the number of control locations simulated in each iteration.}
\item{\code{bandw}}{Vector of length \code{sim_total} of the bandwidth (of numerator) used in each iteration.}
\item{\code{bandw}}{Vector of length \code{sim_total} of the global s statistic.}
\item{\code{bandw}}{Vector of length \code{sim_total} of the global t statistic.}
}
}
\description{
Compute the statistical power of a spatial relative risk function using randomly generated data.
}
\details{
This function computes the statistical power of the spatial relative risk function (nonparametric estimate of relative risk by kernel smoothing) for randomly generated data using various random point pattern generators from the \code{\link{spatstat}} package.

The function uses the \code{\link[sparr]{risk}} function to estimate the spatial relative risk function and forces the \code{tolerate} argument to be TRUE in order to calculate asymptotic p-values.

If \code{samp_case = "uniform"} the case locations are randomly generated uniformly within a disc of radius \code{r_case} (or discs of radii \code{r_case}) centered at coordinates (\code{x_case}, \code{y_case}).

If \code{samp_case = "MVN"} the case locations are randomly generated assuming a multivariate normal distribution centered at coordinates (\code{x_case}, \code{y_case}) with a standard deviation of \code{s_case}.

If \code{samp_case = "CSR"} the case locations are randomly generated assuming complete spatial randomness (homogeneous Poisson process) within a disc of radius \code{r_case} (or discs of radii \code{r_case}) centered at coordinates (\code{x_case}, \code{y_case}) with \code{lambda = n_case / area of disc}.

If \code{samp_case = "IPP"} the case locations are randomly generated assuming an inhomogeneous Poisson process with a disc of radius \code{r_case} (or discs of radii \code{r_case}) centered at coordinates (\code{x_case}, \code{y_case}) with \code{lambda = l_case}, a function.

If \code{samp_control = "uniform"} the control locations are randomly generated uniformly within the window \code{win}.

If \code{samp_control = "systematic"} the control locations are randomly generated systematically within the window \code{win} consisting of a grid of equally-spaced points with a random common displacement.

If \code{samp_control = "MVN"} the control locations are randomly generated assuming a multivariate normal distribution centered at coordinates (\code{x_control}, \code{y_control}) with a standard deviation of \code{s_control}.

If \code{samp_control = "CSR"} the control locations are randomly generated assuming complete spatial randomness (homogeneous Poisson process) within the window \code{win} with a \code{lambda = n_control / [resolution x resolution]} By default, the resolution is an integer value of 128 and can be specified using the \code{resolution} argument in the internally called \code{\link[sparr]{risk}} function.

If \code{samp_control = "IPP"} the control locations are randomly generated assuming an inhomogeneous Poisson process within the window \code{win} with a \code{lambda = l_control}, a function.

If \code{samp_control = "clustered"} the control locations are randomly generated with a realisation of the Neyman-Scott process within the window \code{win} with the intensity of the Poisson process cluster centres (\code{kappa = l_control}), the size of the expansion of the simulation window for generative parent points (\code{e_control}), and the radius (or radii) of the disc for each cluster (\code{r_control}).
}
\examples{
 spatial_power(x_case = c(0.25, 0.5, 0.75),
               y_case = c(0.75, 0.25, 0.75),
               samp_case = "MVN", 
               samp_control = "MVN",
               x_control = c(0.25, 0.5, 0.75),
               y_control = c(0.75, 0.25, 0.75),
               n_case = 100,
               n_control = c(100,500,300),
               s_case = c(0.05,0.01,0.05),
               s_control = 0.05,
               verbose = FALSE
               )

}
