% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spark_compile.R
\name{spark_compilation_spec}
\alias{spark_compilation_spec}
\title{Define a Spark Compilation Specification}
\usage{
spark_compilation_spec(
  spark_version = NULL,
  spark_home = NULL,
  scalac_path = NULL,
  scala_filter = NULL,
  jar_name = NULL,
  jar_path = NULL,
  jar_dep = NULL,
  embedded_srcs = "embedded_sources.R"
)
}
\arguments{
\item{spark_version}{The Spark version to build against. This can
be left unset if the path to a suitable Spark home is supplied.}

\item{spark_home}{The path to a Spark home installation. This can
be left unset if \code{spark_version} is supplied; in such a case,
\code{sparklyr} will attempt to discover the associated Spark
installation using \code{\link{spark_home_dir}}.}

\item{scalac_path}{The path to the \code{scalac} compiler to be used
during compilation of your Spark extension. Note that you should
ensure the version of \code{scalac} selected matches the version of
\code{scalac} used with the version of Spark you are compiling against.}

\item{scala_filter}{An optional \R function that can be used to filter
which \code{scala} files are used during compilation. This can be
useful if you have auxiliary files that should only be included with
certain versions of Spark.}

\item{jar_name}{The name to be assigned to the generated \code{jar}.}

\item{jar_path}{The path to the \code{jar} tool to be used
during compilation of your Spark extension.}

\item{jar_dep}{An optional list of additional \code{jar} dependencies.}

\item{embedded_srcs}{Embedded source file(s) under \code{<R package root>/java} to
be included in the root of the resulting jar file as resources}
}
\description{
For use with \code{\link{compile_package_jars}}. The Spark compilation
specification is used when compiling Spark extension Java Archives, and
defines which versions of Spark, as well as which versions of Scala, should
be used for compilation.
}
\details{
Most Spark extensions won't need to define their own compilation specification,
and can instead rely on the default behavior of \code{compile_package_jars}.
}
