/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.spark.sql.Row;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.WrappedArray;
import scala.collection.mutable.WrappedArray$;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import scala.util.matching.Regex;
import sparklyr.Collectors;
import sparklyr.Numeric;
import sparklyr.StructTypeAsJSON;
import sparklyr.StructTypeAsJSON$;

public final class Collectors$ {
    public static Collectors$ MODULE$;
    private final Function2<Row, Object, String> collectForceString;
    private final Function2<Row, Object, String> collectString;

    static {
        new Collectors$();
    }

    public int collectBoolean(Row row, int idx) {
        Object el = row.apply(idx);
        return el instanceof Boolean ? (BoxesRunTime.unboxToBoolean((Object)el) ? 1 : 0) : Integer.MIN_VALUE;
    }

    public int[] collectBooleanArr(Row row, int idx) {
        WrappedArray el = (WrappedArray)row.apply(idx);
        return (int[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToInteger((int)Collectors$.$anonfun$collectBooleanArr$1(el, e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
    }

    public int collectInteger(Row row, int idx) {
        Object el = row.apply(idx);
        return el instanceof Integer ? BoxesRunTime.unboxToInt((Object)el) : Integer.MIN_VALUE;
    }

    public int[] collectIntegerArr(Row row, int idx) {
        WrappedArray el = (WrappedArray)row.apply(idx);
        return (int[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToInteger((int)Collectors$.$anonfun$collectIntegerArr$1(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
    }

    public Numeric collectNumeric(Row row, int idx) {
        Object el = row.apply(idx);
        return new Numeric((Option<Object>)(el == null ? None$.MODULE$ : (el instanceof Double ? new Some((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)el))) : new Some((Object)BoxesRunTime.boxToDouble((double)Double.NaN)))));
    }

    public Numeric[] collectNumericArr(Row row, int idx) {
        WrappedArray el = (WrappedArray)row.apply(idx);
        return (Numeric[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> new Numeric((Option<Object>)(e == null ? None$.MODULE$ : (e instanceof Double ? new Some((Object)BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)e))) : new Some((Object)BoxesRunTime.boxToDouble((double)Double.NaN))))), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Numeric.class)))).toArray(ClassTag$.MODULE$.apply(Numeric.class));
    }

    public double collectFloat(Row row, int idx) {
        Object el = row.apply(idx);
        return el instanceof Float ? (double)BoxesRunTime.unboxToFloat((Object)el) : Double.NaN;
    }

    public double[] collectFloatArr(Row row, int idx) {
        WrappedArray el = (WrappedArray)row.apply(idx);
        return (double[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)Collectors$.$anonfun$collectFloatArr$1(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toArray(ClassTag$.MODULE$.Double());
    }

    public int collectByte(Row row, int idx) {
        Object el = row.apply(idx);
        return el instanceof Byte ? (int)BoxesRunTime.unboxToByte((Object)el) : Integer.MIN_VALUE;
    }

    public int[] collectByteArr(Row row, int idx) {
        WrappedArray el = (WrappedArray)row.apply(idx);
        return (int[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToInteger((int)Collectors$.$anonfun$collectByteArr$1(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
    }

    public int collectShort(Row row, int idx) {
        Object el = row.apply(idx);
        return el instanceof Short ? (int)BoxesRunTime.unboxToShort((Object)el) : Integer.MIN_VALUE;
    }

    public int[] collectShortArr(Row row, int idx) {
        WrappedArray el = (WrappedArray)row.apply(idx);
        return (int[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToInteger((int)Collectors$.$anonfun$collectShortArr$1(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toArray(ClassTag$.MODULE$.Int());
    }

    public double collectLong(Row row, int idx) {
        Object el = row.apply(idx);
        return el instanceof Long ? (double)BoxesRunTime.unboxToLong((Object)el) : Double.NaN;
    }

    public double[] collectLongArr(Row row, int idx) {
        WrappedArray el = (WrappedArray)row.apply(idx);
        return (double[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToDouble((double)Collectors$.$anonfun$collectLongArr$1(e)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toArray(ClassTag$.MODULE$.Double());
    }

    public Function2<Row, Object, String> collectForceString() {
        return this.collectForceString;
    }

    public String[] collectForceStringArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (String[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)e -> e != null ? e.toString() : "<NA>", WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public Function2<Row, Object, String> collectString() {
        return this.collectString;
    }

    public String[] collectStringArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (String[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)e -> e instanceof String ? (String)e : "<NA>", WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public double collectDecimal(Row row, int idx) {
        Object el = row.apply(idx);
        return el instanceof BigDecimal ? ((BigDecimal)el).doubleValue() : Double.NaN;
    }

    public double[] collectDecimalArr(Row row, int idx) {
        WrappedArray arr = (WrappedArray)row.apply(idx);
        return (double[])((WrappedArray)arr.map((Function1 & Serializable & scala.Serializable)el -> BoxesRunTime.boxToDouble((double)Collectors$.$anonfun$collectDecimalArr$1(el)), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).toArray(ClassTag$.MODULE$.Double());
    }

    public Object collectVector(Row row, int idx) {
        Object el = row.apply(idx);
        Object object = el;
        Object object2 = object == null ? Array$.MODULE$.empty(ClassTag$.MODULE$.Nothing()) : (object instanceof Seq ? ((Seq)el).toArray(ClassTag$.MODULE$.Any()) : el.getClass().getDeclaredMethod("toArray", new Class[0]).invoke(el, new Object[0]));
        return object2;
    }

    public Object collectJSON(Row row, int idx) {
        Object el = row.apply(idx);
        Object object = el;
        Object object2 = object instanceof String ? new StructTypeAsJSON((String)el) : this.collectDefault(row, idx);
        return object2;
    }

    public Timestamp collectTimestamp(Row row, int idx) {
        return (Timestamp)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Timestamp)row.getAs(idx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
    }

    public Timestamp[] collectTimestampArr(Row row, int idx) {
        WrappedArray el = (WrappedArray)row.apply(idx);
        return (Timestamp[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> (Timestamp)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Timestamp)e).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Timestamp.class)))).toArray(ClassTag$.MODULE$.apply(Timestamp.class));
    }

    public Date collectDate(Row row, int idx) {
        return (Date)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Date)row.getAs(idx)).getOrElse((Function0 & Serializable & scala.Serializable)() -> null);
    }

    public Date[] collectDateArr(Row row, int idx) {
        WrappedArray el = (WrappedArray)row.apply(idx);
        return (Date[])((WrappedArray)el.map((Function1 & Serializable & scala.Serializable)e -> (Date)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> (Date)e).getOrElse((Function0 & Serializable & scala.Serializable)() -> null), WrappedArray$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Date.class)))).toArray(ClassTag$.MODULE$.apply(Date.class));
    }

    public Object collectDefault(Row row, int idx) {
        return row.apply(idx);
    }

    public Collectors.ColumnCtx<? super int[]> mkColumnCtx(String colType, int numRows) {
        Collectors.ColumnCtx columnCtx;
        Regex ReDecimalType = new StringOps(Predef$.MODULE$.augmentString("(DecimalType.*)")).r();
        Regex ReVectorType = new StringOps(Predef$.MODULE$.augmentString("(.*VectorUDT.*)")).r();
        String string = colType;
        if ("BooleanType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectBoolean(row, BoxesRunTime.unboxToInt((Object)idx))), (Manifest)ManifestFactory$.MODULE$.Int(), numRows);
        } else if ("IntegerType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectInteger(row, BoxesRunTime.unboxToInt((Object)idx))), (Manifest)ManifestFactory$.MODULE$.Int(), numRows);
        } else if ("DoubleType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumeric(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(Numeric.class), numRows);
        } else if ("StringType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1(this.collectString(), ManifestFactory$.MODULE$.classType(String.class), numRows);
        } else if ("LongType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToDouble((double)Collectors$.MODULE$.collectLong(row, BoxesRunTime.unboxToInt((Object)idx))), (Manifest)ManifestFactory$.MODULE$.Double(), numRows);
        } else if ("ByteType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectByte(row, BoxesRunTime.unboxToInt((Object)idx))), (Manifest)ManifestFactory$.MODULE$.Int(), numRows);
        } else if ("FloatType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToDouble((double)Collectors$.MODULE$.collectFloat(row, BoxesRunTime.unboxToInt((Object)idx))), (Manifest)ManifestFactory$.MODULE$.Double(), numRows);
        } else if ("ShortType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToInteger((int)Collectors$.MODULE$.collectShort(row, BoxesRunTime.unboxToInt((Object)idx))), (Manifest)ManifestFactory$.MODULE$.Int(), numRows);
        } else if ("Decimal".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), numRows);
        } else if ("TimestampType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectTimestamp(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(Timestamp.class), numRows);
        } else if ("CalendarIntervalType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), numRows);
        } else if ("DateType".equals(string)) {
            columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDate(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.classType(Date.class), numRows);
        } else {
            Option option = ReDecimalType.unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> BoxesRunTime.boxToDouble((double)Collectors$.MODULE$.collectDecimal(row, BoxesRunTime.unboxToInt((Object)idx))), (Manifest)ManifestFactory$.MODULE$.Double(), numRows);
            } else {
                Option option2 = ReVectorType.unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                    columnCtx = Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectVector(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.Any(), numRows);
                } else {
                    String string2 = StructTypeAsJSON$.MODULE$.DType();
                    String string3 = string;
                    columnCtx = !(string2 != null ? !string2.equals(string3) : string3 != null) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectJSON(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.Any(), numRows) : ("ArrayType(BooleanType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectBooleanArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : ("ArrayType(IntegerType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectIntegerArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : ("ArrayType(DoubleType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), numRows) : ("ArrayType(StringType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectStringArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), numRows) : ("ArrayType(LongType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectLongArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Double()), numRows) : ("ArrayType(ByteType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectByteArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : ("ArrayType(FloatType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectFloatArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Double()), numRows) : ("ArrayType(ShortType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectShortArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : ("ArrayType(DecimalType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDecimalArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Double()), numRows) : ("ArrayType(TimestampType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectTimestampArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Timestamp.class)), numRows) : ("ArrayType(CalendarIntervalType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectForceStringArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), numRows) : ("ArrayType(DateType,true)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDateArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Date.class)), numRows) : ("ArrayType(BooleanType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectBooleanArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : ("ArrayType(IntegerType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectIntegerArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : ("ArrayType(DoubleType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectNumericArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Numeric.class)), numRows) : ("ArrayType(StringType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectStringArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), numRows) : ("ArrayType(LongType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectLongArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Double()), numRows) : ("ArrayType(ByteType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectByteArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : ("ArrayType(FloatType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectFloatArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Double()), numRows) : ("ArrayType(ShortType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectShortArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Int()), numRows) : ("ArrayType(DecimalType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDecimalArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType((Manifest)ManifestFactory$.MODULE$.Double()), numRows) : ("ArrayType(TimestampType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectTimestampArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Timestamp.class)), numRows) : ("ArrayType(CalendarIntervalType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectForceStringArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(String.class)), numRows) : ("ArrayType(DateType,false)".equals(string) ? Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDateArr(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.arrayType(ManifestFactory$.MODULE$.classType(Date.class)), numRows) : ("NullType".equals(string) ? Collectors$.newColumnCtx$1(this.collectForceString(), ManifestFactory$.MODULE$.classType(String.class), numRows) : Collectors$.newColumnCtx$1((Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.MODULE$.collectDefault(row, BoxesRunTime.unboxToInt((Object)idx)), ManifestFactory$.MODULE$.Any(), numRows))))))))))))))))))))))))));
                }
            }
        }
        return columnCtx;
    }

    public static final /* synthetic */ int $anonfun$collectBooleanArr$1(WrappedArray el$1, Object e) {
        return e instanceof Boolean ? (BoxesRunTime.unboxToBoolean((Object)el$1) ? 1 : 0) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ int $anonfun$collectIntegerArr$1(Object e) {
        return e instanceof Integer ? BoxesRunTime.unboxToInt((Object)e) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ double $anonfun$collectFloatArr$1(Object e) {
        return e instanceof Float ? (double)BoxesRunTime.unboxToFloat((Object)e) : Double.NaN;
    }

    public static final /* synthetic */ int $anonfun$collectByteArr$1(Object e) {
        return e instanceof Byte ? (int)BoxesRunTime.unboxToByte((Object)e) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ int $anonfun$collectShortArr$1(Object e) {
        return e instanceof Short ? (int)BoxesRunTime.unboxToShort((Object)e) : Integer.MIN_VALUE;
    }

    public static final /* synthetic */ double $anonfun$collectLongArr$1(Object e) {
        return e instanceof Long ? (double)BoxesRunTime.unboxToLong((Object)e) : Double.NaN;
    }

    public static final /* synthetic */ String $anonfun$collectForceString$1(Row row, int idx) {
        Object el = row.apply(idx);
        return el != null ? el.toString() : "<NA>";
    }

    public static final /* synthetic */ String $anonfun$collectString$1(Row row, int idx) {
        Object el = row.apply(idx);
        return el instanceof String ? (String)el : "<NA>";
    }

    public static final /* synthetic */ double $anonfun$collectDecimalArr$1(Object el) {
        return el instanceof BigDecimal ? ((BigDecimal)el).doubleValue() : Double.NaN;
    }

    private static final Collectors.ColumnCtx newColumnCtx$1(Function2 collector, Manifest evidence$2, int numRows$1) {
        return new Collectors.ColumnCtx(collector, numRows$1, evidence$2);
    }

    private Collectors$() {
        MODULE$ = this;
        this.collectForceString = (Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.$anonfun$collectForceString$1(row, BoxesRunTime.unboxToInt((Object)idx));
        this.collectString = (Function2 & Serializable & scala.Serializable)(row, idx) -> Collectors$.$anonfun$collectString$1(row, BoxesRunTime.unboxToInt((Object)idx));
    }
}

