/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import sparklyr.Backend;
import sparklyr.JVMObjectTracker;
import sparklyr.Logger;
import sparklyr.Rscript;
import sparklyr.WorkerContext;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005a\u0001B\u0001\u0003\u0001\u0015\u0011\u0011bV8sW\u0016\u0014(\u000b\u0012#\u000b\u0003\r\t\u0001b\u001d9be.d\u0017P]\u0002\u0001'\t\u0001a\u0001E\u0002\b!Ii\u0011\u0001\u0003\u0006\u0003\u0013)\t1A\u001d3e\u0015\tYA\"A\u0003ta\u0006\u00148N\u0003\u0002\u000e\u001d\u00051\u0011\r]1dQ\u0016T\u0011aD\u0001\u0004_J<\u0017BA\t\t\u0005\r\u0011F\t\u0012\t\u0003'Yi\u0011\u0001\u0006\u0006\u0003+)\t1a]9m\u0013\t9BCA\u0002S_^D\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAB\u0001\u0005aJ,g\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u001d\u0003\u001d\u0019Gn\\:ve\u0016\u00042!\b\u0011#\u001b\u0005q\"\"A\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0005r\"!B!se\u0006L\bCA\u000f$\u0013\t!cD\u0001\u0003CsR,\u0007\u0002\u0003\u0014\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\u0002\u000f\r|G.^7ogB\u0019Q\u0004\t\u0015\u0011\u0005%bcBA\u000f+\u0013\tYc$\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016\u001f\u0011!\u0001\u0004A!A!\u0002\u0013A\u0013AB2p]\u001aLw\r\u0003\u00053\u0001\t\u0005\t\u0015!\u00034\u0003\u0011\u0001xN\u001d;\u0011\u0005u!\u0014BA\u001b\u001f\u0005\rIe\u000e\u001e\u0005\to\u0001\u0011\t\u0011)A\u0005O\u00059qM]8va\nK\b\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u0019\rdwn];sKJc\u0015M\\4\t\u0011m\u0002!\u0011!Q\u0001\n!\n!BY;oI2,\u0007+\u0019;i\u0011!i\u0004A!A!\u0002\u0013q\u0014!C2vgR|W.\u00128w!\u0011Is\b\u000b\u0015\n\u0005\u0001s#aA'ba\"A!\t\u0001B\u0001B\u0003%1'A\td_:tWm\u0019;j_:$\u0016.\\3pkRD\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\bG>tG/\u001a=u\u0011!1\u0005A!A!\u0002\u0013q\u0014aB8qi&|gn\u001d\u0005\u0006\u0011\u0002!\t!S\u0001\u0007y%t\u0017\u000e\u001e \u0015\u001b)cUJT(Q#J\u001bF+\u0016,X!\tY\u0005!D\u0001\u0003\u0011\u0015Ir\t1\u0001\u0007\u0011\u0015Yr\t1\u0001\u001d\u0011\u00151s\t1\u0001(\u0011\u0015\u0001t\t1\u0001)\u0011\u0015\u0011t\t1\u00014\u0011\u00159t\t1\u0001(\u0011\u0015It\t1\u0001\u001d\u0011\u0015Yt\t1\u0001)\u0011\u0015it\t1\u0001?\u0011\u0015\u0011u\t1\u00014\u0011\u0015!u\t1\u0001\u001d\u0011\u00151u\t1\u0001?\u0011\u0019I\u0006\u0001)Q\u00055\u0006IQ\r_2faRLwN\u001c\t\u0004;mk\u0016B\u0001/\u001f\u0005\u0019y\u0005\u000f^5p]B\u0011aL\u001a\b\u0003?\u0012t!\u0001Y2\u000e\u0003\u0005T!A\u0019\u0003\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012BA3\u001f\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u001a5\u0003\u0013\u0015C8-\u001a9uS>t'BA3\u001f\u0011\u0019Q\u0007\u0001)Q\u0005g\u0005Y!-Y2lK:$\u0007k\u001c:u\u0011\u0015a\u0007\u0001\"\u0011n\u000359W\r\u001e)beRLG/[8ogV\ta\u000eE\u0002\u001eA=\u0004\"\u0001]9\u000e\u0003)I!A\u001d\u0006\u0003\u0013A\u000b'\u000f^5uS>t\u0007\"\u0002;\u0001\t\u0003*\u0018aB2p[B,H/\u001a\u000b\u0004mf\\\bc\u00010x%%\u0011\u0001\u0010\u001b\u0002\t\u0013R,'/\u0019;pe\")!p\u001da\u0001_\u0006)1\u000f\u001d7ji\")Ap\u001da\u0001{\u0006!A/Y:l!\t\u0001h0\u0003\u0002\u0000\u0015\tYA+Y:l\u0007>tG/\u001a=u\u0001")
public class WorkerRDD
extends RDD<Row> {
    private final byte[] closure;
    private final String[] columns;
    public final String sparklyr$WorkerRDD$$config;
    private final int port;
    private final String[] groupBy;
    private final byte[] closureRLang;
    private final String bundlePath;
    public final Map<String, String> sparklyr$WorkerRDD$$customEnv;
    private final int connectionTimeout;
    private final byte[] context;
    public final Map<String, String> sparklyr$WorkerRDD$$options;
    public Option<Exception> sparklyr$WorkerRDD$$exception;
    public int sparklyr$WorkerRDD$$backendPort;

    public Partition[] getPartitions() {
        return this.firstParent(ClassTag$.MODULE$.Nothing()).partitions();
    }

    public Iterator<Row> compute(Partition split, TaskContext task) {
        int sessionId = Random$.MODULE$.nextInt(10000);
        Logger logger = new Logger("Worker", sessionId);
        Object lock = new Object();
        WorkerContext workerContext = new WorkerContext((Row[])this.firstParent(ClassTag$.MODULE$.Nothing()).iterator(split, task).toArray(ClassTag$.MODULE$.apply(Row.class)), lock, this.closure, this.columns, this.groupBy, this.closureRLang, this.bundlePath, this.context);
        JVMObjectTracker tracker = new JVMObjectTracker();
        String contextId = tracker.put(workerContext);
        logger.log(new StringBuilder().append((Object)"is tracking worker context under ").append((Object)contextId).toString());
        logger.log("initializing backend");
        Backend backend = new Backend();
        backend.setTracker(tracker);
        backend.setType(true, false, true);
        backend.setHostContext(contextId);
        backend.init(this.port, sessionId, this.connectionTimeout);
        this.sparklyr$WorkerRDD$$backendPort = backend.getPort();
        new Thread(this, logger, lock, backend){
            private final /* synthetic */ WorkerRDD $outer;
            private final Logger logger$1;
            private final Object lock$1;
            private final Backend backend$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    this.logger$1.log("starting backend");
                    this.backend$1.run();
                    return;
                }
                catch (Exception exception) {
                    this.logger$1.logError("failed while running backend: ", exception);
                    this.$outer.sparklyr$WorkerRDD$$exception = new Some((Object)exception);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                        return;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.logger$1 = logger$1;
                this.lock$1 = lock$1;
                this.backend$1 = backend$1;
                super("starting backend thread");
            }
        }.start();
        new Thread(this, sessionId, logger, lock){
            private final /* synthetic */ WorkerRDD $outer;
            private final int sessionId$1;
            private final Logger logger$1;
            private final Object lock$1;

            public void run() {
                try {
                    this.logger$1.log("is starting rscript");
                    Rscript rscript = new Rscript(this.logger$1);
                    rscript.init(this.sessionId$1, this.$outer.sparklyr$WorkerRDD$$backendPort, this.$outer.sparklyr$WorkerRDD$$config, this.$outer.sparklyr$WorkerRDD$$customEnv, this.$outer.sparklyr$WorkerRDD$$options);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
                catch (Exception exception) {
                    this.logger$1.logError("failed to run rscript: ", exception);
                    this.$outer.sparklyr$WorkerRDD$$exception = new Some((Object)exception);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.sessionId$1 = sessionId$1;
                this.logger$1 = logger$1;
                this.lock$1 = lock$1;
                super("starting rscript thread");
            }
        }.start();
        logger.log("is waiting using lock for RScript to complete");
        Object object = lock;
        synchronized (object) {
            lock.wait();
            // ** MonitorExit[lock] (shouldn't be in output)
            logger.log("completed wait using lock for RScript");
            if (this.sparklyr$WorkerRDD$$exception.isDefined()) {
                throw (Throwable)this.sparklyr$WorkerRDD$$exception.get();
            }
            logger.log(new StringBuilder().append((Object)"is returning RDD iterator with ").append((Object)BoxesRunTime.boxToInteger((int)workerContext.getResultArray().length)).append((Object)" rows").toString());
            return Predef$.MODULE$.refArrayOps((Object[])workerContext.getResultArray()).iterator();
        }
    }

    public WorkerRDD(RDD<Row> prev, byte[] closure, String[] columns, String config, int port, String[] groupBy2, byte[] closureRLang, String bundlePath, Map<String, String> customEnv, int connectionTimeout, byte[] context, Map<String, String> options) {
        this.closure = closure;
        this.columns = columns;
        this.sparklyr$WorkerRDD$$config = config;
        this.port = port;
        this.groupBy = groupBy2;
        this.closureRLang = closureRLang;
        this.bundlePath = bundlePath;
        this.sparklyr$WorkerRDD$$customEnv = customEnv;
        this.connectionTimeout = connectionTimeout;
        this.context = context;
        this.sparklyr$WorkerRDD$$options = options;
        super(prev, ClassTag$.MODULE$.apply(Row.class));
        this.sparklyr$WorkerRDD$$exception = None$.MODULE$;
        this.sparklyr$WorkerRDD$$backendPort = 0;
    }
}

