% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_evaluator.R
\name{ml_evaluator}
\alias{ml_evaluator}
\alias{ml_binary_classification_evaluator}
\alias{ml_binary_classification_eval}
\alias{ml_multiclass_classification_evaluator}
\alias{ml_classification_eval}
\alias{ml_regression_evaluator}
\title{Spark ML - Evaluators}
\usage{
ml_binary_classification_evaluator(x, label_col = "label",
  raw_prediction_col = "rawPrediction", metric_name = "areaUnderROC",
  uid = random_string("binary_classification_evaluator_"), ...)

ml_binary_classification_eval(x, label_col = "label",
  prediction_col = "prediction", metric_name = "areaUnderROC")

ml_multiclass_classification_evaluator(x, label_col = "label",
  prediction_col = "prediction", metric_name = "f1",
  uid = random_string("multiclass_classification_evaluator_"), ...)

ml_classification_eval(x, label_col = "label",
  prediction_col = "prediction", metric_name = "f1")

ml_regression_evaluator(x, label_col = "label",
  prediction_col = "prediction", metric_name = "rmse",
  uid = random_string("regression_evaluator_"), ...)
}
\arguments{
\item{x}{A \code{spark_connection} object or a \code{tbl_spark} containing label and prediction columns. The latter should be the output of \code{\link{sdf_predict}}.}

\item{label_col}{Name of column string specifying which column contains the true labels or values.}

\item{raw_prediction_col}{Name of column contains the scored probability of a success}

\item{metric_name}{The performance metric. See details.}

\item{uid}{A character string used to uniquely identify the ML estimator.}

\item{...}{Optional arguments; currently unused.}

\item{prediction_col}{Name of the column that contains the predicted
label or value NOT the scored probability. Column should be of type
\code{Double}.}
}
\value{
The calculated performance metric
}
\description{
A set of functions to calculate performance metrics for prediction models. Also see the Spark ML Documentation \href{https://spark.apache.org/docs/latest/api/scala/index.html#org.apache.spark.ml.evaluation.package}{https://spark.apache.org/docs/latest/api/scala/index.html#org.apache.spark.ml.evaluation.package}
}
\details{
The following metrics are supported
  \itemize{
   \item Binary Classification: \code{areaUnderROC} (default) or \code{areaUnderPR} (not available in Spark 2.X.)
   \item Multiclass Classification: \code{f1} (default), \code{precision}, \code{recall}, \code{weightedPrecision}, \code{weightedRecall} or \code{accuracy}; for Spark 2.X: \code{f1} (default), \code{weightedPrecision}, \code{weightedRecall} or \code{accuracy}.
   \item Regression: \code{rmse} (root mean squared error, default),
   \code{mse} (mean squared error), \code{r2}, or \code{mae} (mean absolute error.)
  }

\code{ml_binary_classification_eval()} is an alias for \code{ml_binary_classification_evaluator()} for backwards compatibility.

\code{ml_classification_eval()} is an alias for \code{ml_multiclass_classification_evaluator()} for backwards compatibility.
}
