/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import org.apache.spark.Partition;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Random$;
import sparklyr.Backend;
import sparklyr.JVMObjectTracker$;
import sparklyr.Logger;
import sparklyr.Rscript;
import sparklyr.WorkerContext;

@ScalaSignature(bytes="\u0006\u0001u4A!\u0001\u0002\u0001\u000b\tIqk\u001c:lKJ\u0014F\t\u0012\u0006\u0002\u0007\u0005A1\u000f]1sW2L(o\u0001\u0001\u0014\u0005\u00011\u0001cA\u0004\u0011%5\t\u0001B\u0003\u0002\n\u0015\u0005\u0019!\u000f\u001a3\u000b\u0005-a\u0011!B:qCJ\\'BA\u0007\u000f\u0003\u0019\t\u0007/Y2iK*\tq\"A\u0002pe\u001eL!!\u0005\u0005\u0003\u0007I#E\t\u0005\u0002\u0014-5\tAC\u0003\u0002\u0016\u0015\u0005\u00191/\u001d7\n\u0005]!\"a\u0001*po\"A\u0011\u0004\u0001B\u0001B\u0003%a!\u0001\u0003qe\u00164\b\u0002C\u000e\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000f\rdwn];sKB\u0019Q\u0004\t\u0012\u000e\u0003yQ\u0011aH\u0001\u0006g\u000e\fG.Y\u0005\u0003Cy\u0011Q!\u0011:sCf\u0004\"!H\u0012\n\u0005\u0011r\"\u0001\u0002\"zi\u0016D\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\bG>dW/\u001c8t!\ri\u0002\u0005\u000b\t\u0003S1r!!\b\u0016\n\u0005-r\u0012A\u0002)sK\u0012,g-\u0003\u0002.]\t11\u000b\u001e:j]\u001eT!a\u000b\u0010\t\u0011A\u0002!\u0011!Q\u0001\n!\naaY8oM&<\u0007\u0002\u0003\u001a\u0001\u0005\u0003\u0005\u000b\u0011B\u001a\u0002\tA|'\u000f\u001e\t\u0003;QJ!!\u000e\u0010\u0003\u0007%sG\u000f\u0003\u00058\u0001\t\u0005\t\u0015!\u0003(\u0003\u001d9'o\\;q\u0005fD\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\rG2|7/\u001e:f%2\u000bgn\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005Q\u0005Q!-\u001e8eY\u0016\u0004\u0016\r\u001e5\t\u0011u\u0002!\u0011!Q\u0001\ny\n\u0011bY;ti>lWI\u001c<\u0011\t%z\u0004\u0006K\u0005\u0003\u0001:\u00121!T1q\u0011!\u0011\u0005A!A!\u0002\u0013\u0019\u0014!E2p]:,7\r^5p]RKW.Z8vi\"AA\t\u0001B\u0001B\u0003%A$A\u0004d_:$X\r\u001f;\t\u000b\u0019\u0003A\u0011A$\u0002\rqJg.\u001b;?)1A%j\u0013'N\u001d>\u0003\u0016KU*U!\tI\u0005!D\u0001\u0003\u0011\u0015IR\t1\u0001\u0007\u0011\u0015YR\t1\u0001\u001d\u0011\u00151S\t1\u0001(\u0011\u0015\u0001T\t1\u0001)\u0011\u0015\u0011T\t1\u00014\u0011\u00159T\t1\u0001(\u0011\u0015IT\t1\u0001\u001d\u0011\u0015YT\t1\u0001)\u0011\u0015iT\t1\u0001?\u0011\u0015\u0011U\t1\u00014\u0011\u0015!U\t1\u0001\u001d\u0011\u00191\u0006\u0001)Q\u0005/\u0006IQ\r_2faRLwN\u001c\t\u0004;aS\u0016BA-\u001f\u0005\u0019y\u0005\u000f^5p]B\u00111l\u0019\b\u00039\u0006t!!\u00181\u000e\u0003yS!a\u0018\u0003\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0012B\u00012\u001f\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Z3\u0003\u0013\u0015C8-\u001a9uS>t'B\u00012\u001f\u0011\u00199\u0007\u0001)Q\u0005g\u0005Y!-Y2lK:$\u0007k\u001c:u\u0011\u0015I\u0007\u0001\"\u0011k\u000359W\r\u001e)beRLG/[8ogV\t1\u000eE\u0002\u001eA1\u0004\"!\u001c8\u000e\u0003)I!a\u001c\u0006\u0003\u0013A\u000b'\u000f^5uS>t\u0007\"B9\u0001\t\u0003\u0012\u0018aB2p[B,H/\u001a\u000b\u0004gZD\bcA.u%%\u0011Q/\u001a\u0002\t\u0013R,'/\u0019;pe\")q\u000f\u001da\u0001Y\u0006)1\u000f\u001d7ji\")\u0011\u0010\u001da\u0001u\u0006!A/Y:l!\ti70\u0003\u0002}\u0015\tYA+Y:l\u0007>tG/\u001a=u\u0001")
public class WorkerRDD
extends RDD<Row> {
    private final byte[] closure;
    private final String[] columns;
    public final String sparklyr$WorkerRDD$$config;
    private final int port;
    private final String[] groupBy;
    private final byte[] closureRLang;
    private final String bundlePath;
    public final Map<String, String> sparklyr$WorkerRDD$$customEnv;
    private final int connectionTimeout;
    private final byte[] context;
    public Option<Exception> sparklyr$WorkerRDD$$exception;
    public int sparklyr$WorkerRDD$$backendPort;

    public Partition[] getPartitions() {
        return this.firstParent(ClassTag$.MODULE$.Nothing()).partitions();
    }

    public Iterator<Row> compute(Partition split, TaskContext task) {
        int sessionId = Random$.MODULE$.nextInt(10000);
        Logger logger = new Logger("Worker", sessionId);
        Object lock = new Object();
        WorkerContext workerContext = new WorkerContext((Row[])this.firstParent(ClassTag$.MODULE$.Nothing()).iterator(split, task).toArray(ClassTag$.MODULE$.apply(Row.class)), lock, this.closure, this.columns, this.groupBy, this.closureRLang, this.bundlePath, this.context);
        String contextId = JVMObjectTracker$.MODULE$.put(workerContext);
        logger.log(new StringBuilder().append((Object)"is tracking worker context under ").append((Object)contextId).toString());
        logger.log("initializing backend");
        Backend backend = new Backend();
        backend.setType(true, false, true);
        backend.setHostContext(contextId);
        backend.init(this.port, sessionId, this.connectionTimeout);
        this.sparklyr$WorkerRDD$$backendPort = backend.getPort();
        new Thread(this, logger, lock, backend){
            private final /* synthetic */ WorkerRDD $outer;
            private final Logger logger$1;
            private final Object lock$1;
            private final Backend backend$1;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                try {
                    this.logger$1.log("starting backend");
                    this.backend$1.run();
                    return;
                }
                catch (Exception exception) {
                    this.logger$1.logError("failed while running backend: ", exception);
                    this.$outer.sparklyr$WorkerRDD$$exception = new Some((Object)exception);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                        return;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.logger$1 = logger$1;
                this.lock$1 = lock$1;
                this.backend$1 = backend$1;
                super("starting backend thread");
            }
        }.start();
        new Thread(this, sessionId, logger, lock){
            private final /* synthetic */ WorkerRDD $outer;
            private final int sessionId$1;
            private final Logger logger$1;
            private final Object lock$1;

            public void run() {
                try {
                    this.logger$1.log("is starting rscript");
                    Rscript rscript = new Rscript(this.logger$1);
                    rscript.init(this.sessionId$1, this.$outer.sparklyr$WorkerRDD$$backendPort, this.$outer.sparklyr$WorkerRDD$$config, this.$outer.sparklyr$WorkerRDD$$customEnv);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
                catch (Exception exception) {
                    this.logger$1.logError("failed to run rscript: ", exception);
                    this.$outer.sparklyr$WorkerRDD$$exception = new Some((Object)exception);
                    Object object = this.lock$1;
                    synchronized (object) {
                        this.lock$1.notify();
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sessionId$1 = sessionId$1;
                this.logger$1 = logger$1;
                this.lock$1 = lock$1;
                super("starting rscript thread");
            }
        }.start();
        logger.log("is waiting using lock for RScript to complete");
        Object object = lock;
        synchronized (object) {
            lock.wait();
            // ** MonitorExit[lock] (shouldn't be in output)
            logger.log("completed wait using lock for RScript");
            if (this.sparklyr$WorkerRDD$$exception.isDefined()) {
                throw (Throwable)this.sparklyr$WorkerRDD$$exception.get();
            }
            logger.log(new StringBuilder().append((Object)"is returning RDD iterator with ").append((Object)BoxesRunTime.boxToInteger((int)workerContext.getResultArray().length)).append((Object)" rows").toString());
            return Predef$.MODULE$.refArrayOps((Object[])workerContext.getResultArray()).iterator();
        }
    }

    public WorkerRDD(RDD<Row> prev, byte[] closure, String[] columns, String config, int port, String[] groupBy2, byte[] closureRLang, String bundlePath, Map<String, String> customEnv, int connectionTimeout, byte[] context) {
        this.closure = closure;
        this.columns = columns;
        this.sparklyr$WorkerRDD$$config = config;
        this.port = port;
        this.groupBy = groupBy2;
        this.closureRLang = closureRLang;
        this.bundlePath = bundlePath;
        this.sparklyr$WorkerRDD$$customEnv = customEnv;
        this.connectionTimeout = connectionTimeout;
        this.context = context;
        super(prev, ClassTag$.MODULE$.apply(Row.class));
        this.sparklyr$WorkerRDD$$exception = None$.MODULE$;
        this.sparklyr$WorkerRDD$$backendPort = 0;
    }
}

