% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_gradient_boosted_tree.R
\name{ml_gradient_boosted_trees}
\alias{ml_gradient_boosted_trees}
\title{Spark ML -- Gradient-Boosted Tree}
\usage{
ml_gradient_boosted_trees(x, response, features, impurity = c("auto", "gini",
  "entropy", "variance"), loss.type = c("auto", "logistic", "squared",
  "absolute"), max.bins = 32L, max.depth = 5L, num.trees = 20L,
  min.info.gain = 0, min.rows = 1L, learn.rate = 0.1, sample.rate = 1,
  type = c("auto", "regression", "classification"), thresholds = NULL,
  seed = NULL, checkpoint.interval = 10L, cache.node.ids = FALSE,
  max.memory = 256L, ml.options = ml_options(), ...)
}
\arguments{
\item{x}{An object coercable to a Spark DataFrame (typically, a
\code{tbl_spark}).}

\item{response}{The name of the response vector (as a length-one character
vector), or a formula, giving a symbolic description of the model to be
fitted. When \code{response} is a formula, it is used in preference to other
parameters to set the \code{response}, \code{features}, and \code{intercept}
parameters (if available). Currently, only simple linear combinations of
existing parameters is supposed; e.g. \code{response ~ feature1 + feature2 + ...}.
The intercept term can be omitted by using \code{- 1} in the model fit.}

\item{features}{The name of features (terms) to use for the model fit.}

\item{impurity}{Criterion used for information gain calculation
One of 'auto', 'gini', 'entropy', or 'variance'. 'auto' defaults to
'gini' for classification and 'variance' for regression.}

\item{loss.type}{Loss function which the algorithm tries to minimize. Defaults to \code{logistic}
for classification and \code{squared} for regression.}

\item{max.bins}{The maximum number of bins used for discretizing
continuous features and for choosing how to split on features at
each node. More bins give higher granularity.}

\item{max.depth}{Maximum depth of the tree (>= 0); that is, the maximum
number of nodes separating any leaves from the root of the tree.}

\item{num.trees}{Number of trees to train (>= 1), defaults to 20.}

\item{min.info.gain}{Minimum information gain for a split to be considered at a tree node. Should be >= 0, defaults to 0.}

\item{min.rows}{Minimum number of instances each child must have after split.}

\item{learn.rate}{The learning rate or step size, defaults to 0.1.}

\item{sample.rate}{Fraction of the training data used for learning each decision tree, defaults to 1.0.}

\item{type}{The type of model to fit. \code{"regression"} treats the response
as a continuous variable, while \code{"classification"} treats the response
as a categorical variable. When \code{"auto"} is used, the model type is
inferred based on the response variable type -- if it is a numeric type,
then regression is used; classification otherwise.}

\item{thresholds}{Thresholds in multi-class classification to adjust
the probability of predicting each class. Vector must have length equal
to the number of classes, with values > 0 excepting that at most one
value may be 0. The class with largest value p/t is predicted, where p
is the original probability of that class and t is the class's threshold.}

\item{seed}{Seed for random numbers.}

\item{checkpoint.interval}{Set checkpoint interval (>= 1) or disable checkpoint (-1).
E.g. 10 means that the cache will get checkpointed every 10 iterations, defaults to 10.}

\item{cache.node.ids}{If \code{FALSE}, the algorithm will pass trees to executors to match instances with nodes.
If \code{TRUE}, the algorithm will cache node IDs for each instance. Caching can speed up training of deeper trees.
Defaults to \code{FALSE}.}

\item{max.memory}{Maximum memory in MB allocated to histogram aggregation. If too small, then 1 node will be split per iteration,
and its aggregates may exceed this size. Defaults to 256.}

\item{ml.options}{Optional arguments, used to affect the model generated. See
\code{\link{ml_options}} for more details.}

\item{...}{Optional arguments. The \code{data} argument can be used to
specify the data to be used when \code{x} is a formula; this allows calls
of the form \code{ml_linear_regression(y ~ x, data = tbl)}, and is
especially useful in conjunction with \code{\link{do}}.}
}
\description{
Perform regression or classification using gradient-boosted trees.
}
\seealso{
Other Spark ML routines: \code{\link{ml_als_factorization}},
  \code{\link{ml_decision_tree}},
  \code{\link{ml_generalized_linear_regression}},
  \code{\link{ml_kmeans}}, \code{\link{ml_lda}},
  \code{\link{ml_linear_regression}},
  \code{\link{ml_logistic_regression}},
  \code{\link{ml_multilayer_perceptron}},
  \code{\link{ml_naive_bayes}},
  \code{\link{ml_one_vs_rest}}, \code{\link{ml_pca}},
  \code{\link{ml_random_forest}},
  \code{\link{ml_survival_regression}}
}
