% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_saveload.R
\name{ml_saveload}
\alias{ml_saveload}
\alias{ml_load}
\alias{ml_save}
\title{Save / Load a Spark ML Model Fit}
\usage{
ml_load(sc, file, meta = ml_load_meta(file))

ml_save(model, file, meta = ml_save_meta(model, file))
}
\arguments{
\item{sc}{A \code{spark_connection}.}

\item{file}{The path where the Spark model should be serialized / deserialized.}

\item{meta}{The path where the \R metadata should be serialized / deserialized.
Currently, this must be a local filesystem path. Alternatively, this can be
an \R function that saves / loads the metadata object.}

\item{model}{A \code{ml_model} fit.}
}
\description{
Save / load a \code{ml_model} fit.
}
\details{
These functions are currently experimental and not yet ready for production
use. Unfortunately, the training summary information for regression fits
(linear, logistic, generalized) are currently not serialized as part of the
model fit, and so model fits recovered through \code{ml_load} will not work
with e.g. \code{fitted}, \code{residuals}, and so on. Such fits should still
be suitable for generating predictions with new data, however.
}
