% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screening_classes.R
\name{screen_cor}
\alias{screen_cor}
\title{Screening coefficient based  on correlation}
\usage{
screen_cor(..., control = list())
}
\arguments{
\item{...}{includes arguments which can be passed as attributes to the
\code{'screencoef'} object}

\item{control}{list of controls to be passed to the screening function}
}
\value{
object of class \code{'screencoef'} which is a list with elements
\itemize{
\item \code{name} (character)
\item \code{control} (list of controls passed as an argument)
\item \code{generate_fun}  for generating the screening coefficient.
This function should have arguments  and   \code{y} (vector of (standardized for Gaussian) responses),
\code{x} (the matrix of standardized predictors) and a \code{'screencoef'} object.
}
}
\description{
Creates an object class \code{'screencoef'} using arguments passed by user,
where the screening coefficient should be computed based on the correlation
coefficient of response and each predictor separately.
}
\details{
Creates an object class \code{'screencoef'} using arguments passed by user.

The function \code{generate_fun} relies on \link[stats]{cor}.

Arguments related to the screening procedure can
be passed to the \code{screen_cor()} function through \code{...}, and
will be saved as attributes of the \code{'screencoef'} object.
The following attributes are relevant for \link{spar} and \link{spar.cv}:
\itemize{
\item \code{nscreen} integer giving the number of variables to be retained
after screening; if not specified, defaults to $2n$.
\item \code{split_data_prop}, double between 0 and 1 which indicates the
proportion of the data that should be used for computing the screening
coefficient. The remaining data will be used for estimating the marginal
models in the SPAR algorithm; if not specified, the whole data will be used
for estimating the screening coefficient and the marginal models.
\item \code{type} character - either \code{"prob"} (indicating that
probabilistic screening should be employed)  or \code{"fixed"} (indicating
that a fixed set of \code{nscreen} variables should be employed across the
ensemble); defaults to \code{type = "prob"}.
\item \code{reuse_in_rp} logical - indicates whether the screening
coefficient should be reused at a later stage in the construction of the random
projection. Defaults to \code{FALSE}.
}
}
\examples{
example_data <- simulate_spareg_data(n = 200, p = 2000, ntest = 100)
spar_res <- spar(example_data$x, example_data$y, xval = example_data$xtest,
  yval = example_data$ytest, nummods=c(5, 10, 15, 20, 25, 30),
  screencoef = screen_cor(control = list(method = "kendall")))

}
