% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_image_overlay.R
\name{get_image_overlay}
\alias{get_image_overlay}
\title{Get an ESRI image overlay for a rayshader map}
\usage{
get_image_overlay(
  bbox,
  overlay = c("World_Imagery", "NatGeo_World_Map", "USA_Topo_Maps",
    "World_Physical_Map", "World_Shaded_Relief", "World_Street_Map", "World_Terrain_Base",
    "World_Topo_Map"),
  img.width = 600,
  img.height = 600,
  lat = NULL,
  lng = NULL,
  save.png = FALSE,
  png.filename = NULL,
  sr_bbox = 4326,
  sr_image = 4326
)
}
\arguments{
\item{bbox}{The bounding box for your image.}

\item{overlay}{One of the available overlays from
\url{https://services.arcgisonline.com/ArcGIS/rest/services}.}

\item{img.width}{Image width, in pixels}

\item{img.height}{Image height, in pixels}

\item{lat}{A quoted string indicating what named value in the bounding box
represents latitude. If NULL, will be inferred from bounding box names.}

\item{lng}{A quoted string indicating what named value in the bounding box
represents longitude. If NULL, will be inferred from bounding box names.}

\item{save.png}{Logical -- should the overlay image be saved?}

\item{png.filename}{Filename for the overlay if \code{save.png} is TRUE.}

\item{sr_bbox}{Spatial reference code (ISO 19111) for bounding box.}

\item{sr_image}{Spatial reference code (ISO 19111) for image.}
}
\value{
A matrix object provided by \code{\link[png]{readPNG}}, suitable for
use with \code{rayshader} and similar mapping utilities. Returned invisibly.
}
\description{
This function calls the ESRI ArcGIS API to retrieve map imagery to overlay
a rayshader map object. It requires a functioning internet connection to
obtain the data.
}
\examples{
\dontrun{
bbox <- get_centroid_bounding_box(c(
  "lat" = 44.121268,
  "lng" = -73.903734
),
distance = 10
)

get_image_overlay(bbox, overlay = "World_Imagery")
}

}
