% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smap.R
\name{smap}
\alias{smap}
\alias{smap,sf-method}
\alias{smap,SpatRaster-method}
\title{smap forecast}
\usage{
\S4method{smap}{sf}(
  data,
  target,
  lib = NULL,
  pred = NULL,
  E = 3,
  tau = 1,
  k = E + 2,
  theta = c(0, 1e-04, 3e-04, 0.001, 0.003, 0.01, 0.03, 0.1, 0.3, 0.5, 0.75, 1, 1.5, 2, 3,
    4, 6, 8),
  nb = NULL,
  threads = detectThreads(),
  trend.rm = TRUE
)

\S4method{smap}{SpatRaster}(
  data,
  target,
  lib = NULL,
  pred = NULL,
  E = 3,
  tau = 1,
  k = E + 2,
  theta = c(0, 1e-04, 3e-04, 0.001, 0.003, 0.01, 0.03, 0.1, 0.3, 0.5, 0.75, 1, 1.5, 2, 3,
    4, 6, 8),
  threads = detectThreads(),
  trend.rm = TRUE
)
}
\arguments{
\item{data}{The observation data.}

\item{target}{Name of target variable.}

\item{lib}{(optional) Libraries indices.}

\item{pred}{(optional) Predictions indices.}

\item{E}{(optional) Dimensions of the embedding.}

\item{tau}{(optional) Step of spatial lags.}

\item{k}{(optional) Number of nearest neighbors used in prediction.}

\item{theta}{(optional) Weighting parameter for distances.}

\item{nb}{(optional) The neighbours list.}

\item{threads}{(optional) Number of threads.}

\item{trend.rm}{(optional) Whether to remove the linear trend.}
}
\value{
A list
\describe{
\item{\code{xmap}}{self mapping prediction results}
\item{\code{varname}}{name of target variable}
}
}
\description{
smap forecast
}
\examples{
columbus = sf::read_sf(system.file("case/columbus.gpkg", package="spEDM"))
\donttest{
smap(columbus,"inc")
}
}
\references{
Sugihara G. 1994. Nonlinear forecasting for the classification of natural time series. Philosophical Transactions: Physical Sciences and Engineering, 348 (1688):477-495.
}
