% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectrogram.R
\name{getFrameBank}
\alias{getFrameBank}
\title{Frame bank}
\usage{
getFrameBank(
  sound,
  samplingRate,
  windowLength_points,
  wn,
  step,
  zp,
  normalize = TRUE,
  filter = NULL,
  padWithSilence = FALSE,
  timeShift = NULL
)
}
\arguments{
\item{sound}{numeric vector}

\item{samplingRate}{sampling rate of \code{x} (only needed if \code{x} is a
numeric vector)}

\item{windowLength_points}{length of fft window (points)}

\item{wn}{window type accepted by \code{\link[seewave]{ftwindow}}, currently
gaussian, hanning, hamming, bartlett, blackman, flattop, rectangle}

\item{step}{you can override \code{overlap} by specifying FFT step, ms (NB:
because digital audio is sampled at discrete time intervals of
1/samplingRate, the actual step and thus the time stamps of STFT frames
may be slightly different, eg 24.98866 instead of 25.0 ms)}

\item{zp}{window length after zero padding, points}

\item{normalize}{if TRUE, scales input prior to FFT}

\item{filter}{fft window filter (defaults to NULL)}

\item{padWithSilence}{if TRUE, pads the sound with just enough silence to
resolve the edges properly (only the original region is plotted, so the
apparent duration doesn't change)}

\item{timeShift}{time (s) added to timestamps}
}
\value{
A matrix with \code{nrow = windowLength_points/2} and \code{ncol}
  depending on \code{length(sound)} and \code{step}
}
\description{
Internal soundgen function.
}
\details{
A subroutine of \code{\link{spec}} that saves windowed (and optionally
zero-padded) frames, i.e. chunks of the sound file of the right size and
spacing. Handy for further processing.
}
\examples{
a = soundgen:::getFrameBank(sin(1:1000), 16000, 512, 'gaussian', 15, 0)
}
\keyword{internal}
