% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/math.R
\name{addVectors}
\alias{addVectors}
\title{Add overlapping vectors}
\usage{
addVectors(v1, v2, insertionPoint = 1, normalize = TRUE)
}
\arguments{
\item{v1, v2}{numeric vectors}

\item{insertionPoint}{the index of element in vector 1 at which vector 2 will
be inserted (any integer, can also be negative)}

\item{normalize}{if TRUE, the output is normalized to range from -1 to +1}
}
\description{
Adds two partly overlapping vectors, such as two waveforms, to produce a
longer vector. The location at which vector 2 is pasted is defined by
insertionPoint. Algorithm: both vectors are padded with zeros to match in
length and then added. All NA's are converted to 0.
}
\examples{
v1 = 1:6
v2 = rep(100, 3)
addVectors(v1, v2, insertionPoint = 5, normalize = FALSE)
addVectors(v1, v2, insertionPoint = -4, normalize = FALSE)
# note the asymmetry: insertionPoint refers to the first arg
addVectors(v2, v1, insertionPoint = -4, normalize = FALSE)

v3 = rep(100, 15)
addVectors(v1, v3, insertionPoint = -4, normalize = FALSE)
addVectors(v2, v3, insertionPoint = 7, normalize = FALSE)
}
\seealso{
\code{\link{soundgen}}
}
