% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_pitch_postprocessing.R
\name{snake}
\alias{snake}
\title{Snake}
\usage{
snake(
  pitch,
  pitchCands,
  pitchCert,
  certWeight,
  pitchCenterGravity,
  snakeStep = 0.05,
  snakePlot = FALSE
)
}
\arguments{
\item{pitch}{numeric vector representing our best guess at pitch contour,
which we are now attempting to improve by minimizing its elastic tension}

\item{pitchCands}{a matrix of multiple pitch candidates per fft frame. Each
column is one fft frame, each row is one candidate (the last row is always
"manual")}

\item{pitchCert}{a matrix of the same dimensionality as pitchCands specifying
our certainty in pitch candidates}

\item{certWeight}{(0 to 1) in pitch postprocessing, specifies how much we
prioritize the certainty of pitch candidates vs. pitch jumps / the internal
tension of the resulting pitch curve}

\item{pitchCenterGravity}{numeric vector giving the mean of all pitch
candidates per fft frame weighted by our certainty in each of these
candidates}

\item{snakeStep}{optimized path through pitch candidates is further
processed to minimize the elastic force acting on pitch contour. To
disable, set \code{snakeStep = 0}}

\item{snakePlot}{if TRUE, plots the snake}
}
\value{
Returns optimized pitch contour (numeric vector of the same length as
  \code{pitch}).
}
\description{
Internal soundgen function.
}
\details{
Internal helper function for postprocessing of pitch contour. Wiggles a snake
along the gradient of internal + external forces. NB: if the snake is run,
the final contour may deviate from the actually measured pitch candidates!
}
\keyword{internal}
