% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_math.R
\name{logMatrix}
\alias{logMatrix}
\title{Log-warp matrix}
\usage{
logMatrix(m, base = 2)
}
\arguments{
\item{m}{a matrix of numeric values of any dimensions (not necessarily
square)}

\item{base}{the base of logarithm}
}
\description{
Internal soundgen function.
}
\details{
Log-warps a matrix, as if log-transforming plot axes.
}
\examples{
m = matrix(1:90, nrow = 10)
soundgen:::logMatrix(m, base = 2)
soundgen:::logMatrix(m, base = 10)

soundgen:::logMatrix(m = matrix(1:9, nrow = 1), base = 2)

\dontrun{
s = spectrogram(soundgen(), 16000, output = 'original')
image(log(t(soundgen:::logMatrix(s, base = 2))))
}
}
\keyword{internal}
