% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invertSpectrogram.R
\name{guessPhase_spsi}
\alias{guessPhase_spsi}
\title{Guess phase SPSI}
\usage{
guessPhase_spsi(spec, windowLength_points, step_points)
}
\arguments{
\item{spec}{the spectrogram that is to be transform to a time series: numeric
matrix with frequency bins in rows and time frames in columns}

\item{windowLength_points}{STFT window length in points}

\item{step_points}{STFT step in points}
}
\value{
Returns a matrix of the same dimensions as `spec` containing the
  guessed phase.
}
\description{
Internal soundgen function.
}
\details{
Single-pass spectrogram inversion as described in Beauregard, G. T., Harish,
M., & Wyse, L. (2015, July). Single pass spectrogram inversion. In 2015 IEEE
International Conference on Digital Signal Processing (DSP) (pp. 427-431).
IEEE. See \code{\link{invertSpectrogram}} for details.
}
\keyword{internal}
