% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/morph.R
\name{morph}
\alias{morph}
\title{Morph sounds}
\usage{
morph(formula1, formula2, nMorphs, playMorphs = TRUE, savePath = NA,
  samplingRate = 16000)
}
\arguments{
\item{formula1, formula2}{lists of parameters for calling
\code{\link{soundgen}} that produce the two target sounds between which
morphing will occur. Character strings containing the full call to soundgen
are also accepted (see examples)}

\item{nMorphs}{the length of morphing sequence, including target sounds}

\item{playMorphs}{if TRUE, the morphing sequence will be played}

\item{savePath}{if it is the path to an existing directory, morphs will be
saved there as individual .wav files (defaults to NA)}

\item{samplingRate}{sampling rate of output, Hz. NB: must be the same as in
\code{formula1} and \code{formula2}!}
}
\value{
A list of two sublists (\code{$formulas} and \code{$sounds}), each
  sublist of length nMorphs. For ex., the formula for the second hybrid is
  \code{m$formulas[[2]]}, and the waveform is \code{m$sounds[[2]]}
}
\description{
Takes two formulas for synthesizing two target sounds with
\code{\link{soundgen}} and produces a number of intermediate forms (morphs),
attempting to go from one target sound to the other in a specified number of
equal steps.
}
\examples{
# write two formulas or copy-paste them from soundgen_app() or presets, for example:
m = morph(formula1 = list(repeatBout = 2),
          # equivalently: formula1 = 'soundgen(repeatBout = 2)',
          formula2 = presets$Misc$Dog_bark,
          nMorphs = 5, playMorphs = FALSE)
 # use $formulas to access formulas for each morph, $sounds for waveforms
 # m$formulas[[4]]
 # playme(m$sounds[[3]])
}
