% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{subset.soundcorrs}
\alias{subset.soundcorrs}
\title{Return a subset of sound correspondences data which meets a condition.}
\usage{
\method{subset}{soundcorrs}(x, condition, ...)
}
\arguments{
\item{x}{[soundcorrs] The dataset to be subsetted.}

\item{condition}{[logical] The condition the subsetted data must meet.}

\item{...}{Unused; only for consistency with \code{\link{subset}}.}
}
\value{
[soundcorrs] A soundcorrs object containing the subsetted dataset.
}
\description{
Reduce a \code{\link{soundcorrs}} object to just those word pairs/triples/... which meet a certain condition.
}
\examples{
# In the examples below, non-ASCII characters had to be escaped for technical reasons.
# In actual usage, all soundcorrs functions accept characters from beyond ASCII.
dataset <- sampleSoundCorrsData.capitals
subset (dataset, OFFICIAL.LANGUAGE=="German")
subset (dataset, grepl("German",OFFICIAL.LANGUAGE))
subset (dataset, findPairs(dataset, "\u00E4", "e")$which)  # a-diaeresis
}
