% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/soundcorrs.R
\name{expandMeta}
\alias{expandMeta}
\title{Expand custom metacharacters to a regular expression.}
\usage{
expandMeta(transcription, x)
}
\arguments{
\item{transcription}{[transcription] The \code{\link{transcription}} to use.}

\item{x}{[character] The string containing metacharacters.}
}
\value{
[character] A string with metacharacters expanded.
}
\description{
Turn characters defined in a \code{\link{transcription}} as metacharacters into the corresponding regular expression.
}
\examples{
dataset <- sampleSoundCorrsData.capitals
expandMeta (dataset$trans[[1]], "aN")
orth.german <- dataset$data$ORTHOGRAPHY.German
query <- "lin"
orth.german [ grep (query, orth.german) ]
query <- expandMeta (dataset$trans[[1]], "lin$")
orth.german [ grep (query, orth.german) ]
}
