\name{packageSum}
\alias{packageSum}
\alias{packageSum.findFn}
\alias{packageSum.data.frame}
\alias{packageSum.list}
\title{
  Add Info from Installed Packages to PackageSummary
}
\description{
  Obtain a summary by package of a \code{findFn}
  object give it class \code{packageSum}.  
  
  This is a simple function, first calling 
  \code{\link{PackageSum2}}, than assigning 
  class \code{packagesum} to it.  
}
\usage{
packageSum(x,
    fields=c("Title", "Version", "Author", "Maintainer", 
      "Packaged", 'helpPages', 'vignette', 'URL'), 
        lib.loc=NULL, ...)
\method{packageSum}{findFn}(x,
    fields=c("Title", "Version", "Author", "Maintainer",
      "Packaged", 'helpPages', 'vignette', 'URL'), 
        lib.loc=NULL, ...)
\method{packageSum}{data.frame}(x,
    fields=c("Title", "Version", "Author", "Maintainer",
      "Packaged", 'helpPages', 'vignette', 'URL'), 
        lib.loc=NULL, ...)
\method{packageSum}{list}(x,
    fields=c("Title", "Version", "Author", "Maintainer",
      "Packaged", 'helpPages', 'vignette', 'URL'), 
        lib.loc=NULL, ...)
}
\arguments{
  \item{x}{
    a data.frame with columns \code{Package} and \code{Score}.
  }
  \item{fields}{
    character vector of names of columns to add to \code{x}. 
    The function first looks  in the components of
    \code{packageDescription(x$Package[i])}.  'vignette' is 
    obtained via the function of that name.

    Component 'Packaged' receives special treatment.  If
    present, only the portion preceding ';' will be retained. 
    This seems to be a time stamp automatically generated by
    something like \code{R CMD build}.  It is absent for
    packages automatically loaded when R is started.  In such
    cases, the third component of 
    \code{strsplit(packageDescription( x$Package[i])$Built, 
    ..., ';')} will be stored as 'Packaged'.  This seems to be 
    a time stamp automatically generated by something like 
    \code{R CMD INSTALL --build}.
  }
  \item{lib.loc}{
    an optional \code{lib.loc} argument passed to
    \code{packageDescription}.
  }
  \item{\dots}{
    additional arguments (currently unused)
  }
}
\details{
  With an object of class \code{findFn}, call 
  \code{\link{PackageSum2}}, then make it class 
  \code{packageSum}.  
  
  If less than half of the package reference are 
  installed, it prints a note suggesting the 
  user call \code{\link{installPackages}}, because
  much of the information is obtained from 
  the packages' \code{DESCRIPTION} file.  
}
\value{
  a \code{data.frame} of class 
  c('packageSum', 'data.frame').  
}
\author{Spencer Graves}
\seealso{
  \code{\link{findFn}}
  \code{\link{PackageSum2}}
  \code{\link{PackageSummary}}
  \code{\link{installPackages}}
}
\examples{
##
## data.frame method
##
tstdf <- data.frame(Package=c('grid', 'base'), 
            stringsAsFactors=FALSE)
tst2 <- packageSum(tstdf)

##
## list method
##
tstList <- list(PackageSummary=tstdf)

\dontshow{stopifnot(}
all.equal(tst2, packageSum(tstList))
\dontshow{)}
##
## findFn method
##
tst.findFn <- data.frame(
    Package=c('grid', 'base')[c(1,1,2)], 
    Score=2:4, Date=LETTERS[1:3], stringsAsFactors=FALSE)
attr(tst.findFn, 'PackageSummary') <- 
    PackageSummary(tst.findFn)
class(tst.findFn) <- c('findFn', 'data.frame')
tst2. <- packageSum(tst.findFn)

\dontshow{stopifnot(}
all.equal(tst2, tst2.[names(tst2)])
\dontshow{)}
##
## spline example 
##
splineHelp <- findFn("spline", maxPages = 2)
splinePkgs <- packageSum(splineHelp)
}
\keyword{package}
